<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ page trimDirectiveWhitespaces="true" %>
<html>
    <head>
        <link rel="stylesheet" href="../css/bootstrap.min.css">
        <link rel="stylesheet" href="../css/VLite.css">
        <script src="../js/jquery.min.js"></script>
        <script src="../js/bootstrap.min.js"></script>

<script>
        // Javascript backend calls for Vision Lite routing
// Copyright 2011-2017 Visionary Solutions, Inc.

var initted = false;

var jcc_alerts = true;  // Turn on or off my alerts

var interval = 1000;  // Basic update time in milliseconds

var transition_counts = 6;  // Number of times before real thumbnails

var sources = 0;

var displays = 0;


// Private functions

window.onload = function() {
        init();
};

function init()
{
    var lroot;
        initted = true;
        setTimeout("timer_loop()", 100);

}

function jcc_alert(o)
{
        if (jcc_alerts)
        {
                alert(o);
        }
}

function timer_loop()
{
<c:choose>
<c:when test="${not empty endpointList}">
  <c:set var="count" value="0" scope="page" />
  <c:forEach var="endpoint" items="${endpointList}">
    <c:if test="${endpoint.isEncoder()}">
      <c:set var="count" value="${count + 1}" scope="page"/>
      <c:out value="s${count} "/> = document.getElementById('s_img_<c:out value="${count}"/>');
      <c:out value="if((s${count} "/> !== null) && (<c:out value="s${count}"/>.getAttribute('busy') !== 'true'))
      {
        <c:out value="s${count}"/>.setAttribute('busy','true');
        check_image(<c:out value="s${count}"/>, <c:out value="s${count}"/>.getAttribute('thumb'));
      }
    </c:if>
  </c:forEach>
  <c:set var="count" value="0" scope="page" />
  <c:forEach var="display" items="${displayList}">
      <c:set var="count" value="${count + 1}" scope="page"/>
      update_thumbnail('d_img_<c:out value="${count}"/>');
  </c:forEach>
</c:when>
</c:choose>

  setTimeout("timer_loop()", interval);
}

function update_thumbnail(d_id) {
    var d = document.getElementById(d_id);
    if(d.timer == null)
    {
        d.timer = 0;
    }
    if(d.timer == 0)
    {
        if((d !== null) && (d.getAttribute('busy') !== 'true'))
        {
          d.setAttribute('busy','true');
          check_image(d, d.getAttribute('thumb'));
        }
    }
    else if (d.timer > 0)
    {
        if((d !== null) && (d.getAttribute('busy') !== 'true'))
        {
          d.setAttribute('busy','true');
          check_image(d, d.tempThumb);
        }
        d.timer--;
    }
}

function allowDrop(ev) {

var parent;
var here;

  ev.preventDefault();
  here = ev.target;
  parent=document.getElementById(event.target.id).parentNode;
  here.style.background = 'rgba(58,117,196,.5)';
  here.style.opacity = '.5';
  parent.style.zindex = '-1';
}

function dragStart(ev) {
    ev.dataTransfer.setData("id", ev.target.id);
    ev.target.style.zindex='-1';
}

function dropped(ev) {

    ev.preventDefault();
    var display = ev.target;
    display.style.background = 'rgba(255,255,255,1)';
    display.style.opacity = '1';

    var sourceId = ev.dataTransfer.getData("id");
    if( sourceId !== "")
    {
        var source = document.getElementById(sourceId);
        var sImg = source.getElementsByTagName('img')[0];
        var dImg = display.getElementsByTagName('img')[0];

        // alert("You dropped " + sImg.id + " Onto: " + dImg.id);
        dImg.src = sImg.src;  // Change thumbnail immediately, reverts to normal fetch after dImg.timer cycles
        dImg.tempThumb = sImg.getAttribute('thumb');
        dImg.timer = transition_counts;  // Number times through timer_loop before reverting to getting true thumbnails from display

        encoder_uid = source.getAttribute('uid');
        decoder_uid = display.getAttribute('uid');

        params = "&encoder=" + encoder_uid + "&decoder=" + decoder_uid;
        send_post("/routing", "action=route", params, false);
    }
    else
    {
        alert("You managed to select a non-source element, please try again!");
    }
}

function leave(ev) {
var here;

    here = ev.target;
    here.style.background = 'rgba(255,255,255,1)';
    here.style.opacity = '1';
}

function dbl_clicked(ev,ipadd)
{
var loc;
    loc = "http://admin:${password}@" + ipadd;
    window.open(loc,'_blank');
    here = ev.target;
    here.style.opacity = '1';
}

function toggle_thumbnail_size()
{
    lroot = document.documentElement;
    lwidth = getComputedStyle(lroot).getPropertyValue("--source-width");
    if(lwidth == 166)
    {
        lwidth = 86;
        lstmt = 2;
        lstmb = 2;
        lstfs = 9;
    }
    else
    {
        lwidth = 166;
        lstmt = 5;
        lstmb = 5;
        lstfs = 14;
    }
    lheight = lwidth*.75;
    lroot.style.setProperty('--source-width', lwidth);
    lroot.style.setProperty('--source-height', lheight);
    lroot.style.setProperty('--stext-mt', lstmt);
    lroot.style.setProperty('--stext-mb', lstmb);
    lroot.style.setProperty('--stext-fs', lstfs);
}

function check_image(ref, uri_string)
{
    var image = new Image();
    image.addEventListener('error', function(e){image_error(ref,'false');}, false);
    image.addEventListener('load', function(e){image_complete(ref, image);}, false);
    image.src = uri_string + '?x=' + Date();

}

function image_error(ref, value)
{
    ref.setAttribute('busy',value);
    ref.src = '../images/novideo.png';
}

function image_complete(ref, image)
{
    if (image.width > 0)
    {
        ref.src = image.src;
        cursor = document.getElementById('cursorimg');
        if(cursor !== null)
        {
            if(cursor.getAttribute('thumb') === ref.getAttribute('thumb'))
            {
                cursor.src = image.src;
            }
        }
    }
    else
    {
        ref.src = '../images/novideo.png';
    }
    ref.setAttribute('busy','false');
}

function send_post(url, action, params, reload)
{
    var xhr = new XMLHttpRequest();

    xhr.onload = function(e)
    {
        xhrLoaded = 'true';
        postdone(reload);
    };

    xhr.onerror = function(e)
    {
        xhrError = 'true';
        postdone(reload);
    };

    xhr.ontimeout = function(e)
    {
        xhrError = 'true';
        postdone(reload);
    };

    xhr.open ('POST', url, true);
    xhr.setRequestHeader('content-type', 'application/x-www-form-urlencoded');
    xhr.timeout = 3000;
    xhrError = 'false';
    xhrLoaded = 'false';
    done = false;
    xhr.send(action + params);
}

function touchStart(event)
{
  event.preventDefault();

  var obj = event.target;
  var tsimg = obj.getElementsByTagName('img')[0];  // The img of the source that was dropped
  var touch = event.targetTouches[0];
  var cursor = document.createElement('img');
  cursor.setAttribute('id', 'cursorimg');
  cursor.setAttribute('src', tsimg.src);
  cursor.setAttribute('alt', 'na');
  width = tsimg.offsetWidth;
  height = tsimg.offsetHeight;
  cursor.setAttribute('width', width);
  cursor.setAttribute('height', height);
  cursor.style.position = 'absolute';
  cursor.style.pointerEvents = 'none';
  thumb = tsimg.getAttribute('thumb');
  cursor.setAttribute('thumb', thumb);
  cursor.style.left = (touch.pageX - (cursor.width/2))+ 'px';
  cursor.style.top = (touch.pageY - (cursor.height/2)) + 'px';

  document.body.appendChild(cursor);

}

function touchMove(event)
{
    event.preventDefault();

    var cursor = document.getElementById('cursorimg');  // The img of the source that was dropped
    var touch = event.changedTouches[0];
    var offset = getOffset(window);
    x = touch.pageX + offset.left - (cursor.width / 2);
    y = touch.pageY + offset.top - (cursor.height / 2);
    //alert("X1: " + touch.pageX + " Y: " + touch.pageY + "X2: " + x + " Y2: " + y);
    cursor.style.left = x + 'px';
    cursor.style.top = y + 'px';
}

function touchEnd(event)
{
    var touch = event.changedTouches[0];
    var dId;
    x = touch.clientX;
    y = touch.clientY;
    source = event.target;
    display = document.elementFromPoint(x, y);
    cursor = document.getElementById('cursorimg');
    document.body.removeChild(cursor);
    cursor = null;  // this should remove listeners.

    if(source !== null)
    {
        var sImg = source.getElementsByTagName('img')[0];
        var dImg = display.getElementsByTagName('img')[0];
        if(display !== null)
        {
            dId = display.getAttribute('id');
        }
        else
        {
            alert("No element found.");
            return;
        }
        temp = dId.search("display_");
        if((dImg !== null) && (temp !== -1))
        {
            dImg.src = sImg.src;  // Change thumbnail immediately, reverts to normal fetch after dImg.timer cycles
            dImg.tempThumb = sImg.getAttribute('thumb');
            dImg.timer = transition_counts;  // Number times through timer_loop before reverting to getting true thumbnails from display

            encoder_uid = source.getAttribute('uid');
            decoder_uid = display.getAttribute('uid');

            params = "&encoder=" + encoder_uid + "&decoder=" + decoder_uid;
            send_post("/routing", "action=route", params, false);
        }
        else
        {
            alert("You dropped onto a non-display element, please try again.");
        }
    }
    else
    {
        alert("You managed to select a non-source element, please try again.");
    }
}

//Helper function to get correct page offset for the Pointer coords
function getOffset(obj)
{
    var offsetLeft = 0;
    var offsetTop = 0;
    do
    {
        if (!isNaN(obj.offsetLeft))
        {
            offsetLeft += obj.offsetLeft;
        }
        if (!isNaN(obj.offsetTop))
        {
            offsetTop += obj.offsetTop;
        }
    } while(obj = obj.offsetParent );
    return {left: offsetLeft, top: offsetTop};
}

function new_preset()
{
    var pi = document.getElementById("editPresetIndex");
    pindex = pi.value;
    var pn = document.getElementById("editPresetName");
    pname = pn.value;
    params = "&presetindex=" + pindex + "&presetname=" + pname;
    $('#editPresetModal').modal('hide');
    send_post("/routing", "action=newPreset", params, true);
}

function delete_preset()
{
    var pi = document.getElementById("editPresetIndex");
    pindex = pi.value;
    params = "&presetindex=" + pindex;
    $('#editPresetModal').modal('hide');
    send_post("/routing", "action=deletePreset", params, true);
}

function save_preset()
{
    var o = document.getElementById("savePresetIndex");
    pindex = o.options[o.selectedIndex].value;
    temp = o.options[o.selectedIndex];
    pname = temp.getAttribute("name");
    params = "&presetindex=" + pindex + "&presetname=" + pname;
    $('#savePresetModal').modal('hide');
    send_post("/routing", "action=savePreset", params, true);
}

function recall_preset(pindex)
{
    params = "&presetindex=" + pindex;
    $('#recallPresetModal').modal('hide');
    send_post("/routing", "action=loadPreset", params, false);
}

function preset_dialog_recall()
{
    $('#recallPresetModal').modal('show');
}

function preset_dialog_save()
{
    $('#savePresetModal').modal('show');
}

function preset_dialog_edit()
{
    $('#editPresetModal').modal('show');
}

function postdone(reload)
{
    if(reload === true)
    {
        location.reload();
    }
}


function filterText(type) {
  var input, filter, el, td, i, txtValue, lid;
  if(type === "source")
  {
      lid = 'filter_sources';
  }
  else if (type === "display")
  {
      lid = 'filter_displays';
  }
  else
  {
      return -1;
  }
  input = document.getElementById(lid);
  filter = input.value.toUpperCase();
  el = document.getElementsByClassName(type);
  for (i = 0; i < el.length; i++) {
    td = el[i];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        el[i].style.display = "";
      } else {
        el[i].style.display = "none";
      }
    }
  }
}


</script>

    </head>
    <body>
        <!-- Navigation -->
        <jsp:include page="navtop.jsp"/>
        <!-- END Navigation -->
        <div class="container">
            <!-- Bootstrap alert message -->
            <c:if test="${not empty message}">
                <div class="alert alert-info alert-dismissable">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    ${message}
                </div>
            </c:if>
            <!-- END Bootstrap alert message -->
            <!-- Begin Presets Container -->
            <h3 no_select no_event>Presets</h3>
            <div class="well preset">
                <div class="row pbutton">
                    <button id="recallPresetButton" type='button' class='btn btn-primary' onclick="preset_dialog_recall();">Recall</button>
                    <c:choose>
                        <c:when test="${not empty presetList}">
                            <c:set var="count" value="0" scope="page" />
                            <c:forEach var="preset" items="${presetList}">
                                <c:set var="count" value="${count + 1}" scope="page"/>
                                <c:if test="${count <= 6}">
                                    <button type='button' class='btn btn-default pbutton' onclick="recall_preset('${preset.getIndex()}');">${preset.getName()}</button>
                                </c:if>
                            </c:forEach>
                        </c:when>
                        <c:otherwise>
                            <div class="alert alert-info" style="width: 50%; display: inline;">
                                No presets found
                            </div>
                        </c:otherwise>
                    </c:choose>
                    <div class="pull-right">
                        <button id="savePresetButton" type='button' class='btn btn-primary' onclick="preset_dialog_save();">Save</button>
                        <button id="editPresetButton" type='button' class='btn btn-primary' onclick="preset_dialog_edit();">Edit</button>
                    </div>
                </div>
            </div>
            <div>
                <h3 class='no_select' onclick="toggle_thumbnail_size();">Sources</h3>
                <input type=text' id='filter_sources' onkeyup="filterText('source');" placeholder='Filter Sources:' title=Filter' style="margin-bottom: 5px;">
            </div>
            <div class="well no_select scroller source_well">
                <div id='sources_div' class='row no_select no_event'>
                    <c:choose>
                        <c:when test="${not empty endpointList}">
                            <c:set var="count" value="0" scope="page" />
                            <c:forEach var="endpoint" items="${endpointList}">
                                <c:if test="${endpoint.isEncoder()}">
                                    <c:set var="count" value="${count + 1}" scope="page"/>
                                    <div id="source_${count}"
                                        draggable='true'
                                        droppable='false'
                                        ondragstart='dragStart(event)'
                                        onmouseover='clearSelections(event)'
                                        ontouchstart='touchStart(event)'
                                        ontouchmove='touchMove(event)'
                                        ontouchend='touchEnd(event)'
                                        ondblclick='dbl_clicked(event,"${endpoint.ipAddress}")'
                                        uid = "${endpoint.macAddress}"
                                        class = 'source thumbnail yes_select auto_event col-xs-6 col-md-2 col-sm-3'
                                        name="${endpoint.id}" >
                                        <img id='s_img_${count}'
                                             thumb="http://${endpoint.ipAddress}/thumb.jpg"
                                             alt='Source'
                                             class='source_img no_select'
                                             src='../images/novideo.png'
                                             onerror="this.src='../images/novideo.png';">
                                        <div style='text-align:center;' class='caption no_event no_select'>
                                            <p class='stext' >${endpoint.id}<p>
                                        </div>
                                    </div><!-- source div end -->
                                </c:if>
                            </c:forEach>
                        </c:when>
                        <c:otherwise>
                            <br>
                            <div class="alert alert-info">
                                No endpoints found matching your search criteria
                                ${text}
                            </div>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div>
                <h3 class='no_select' onclick="toggle_thumbnail_size();">Displays</h3>
                <input type=text' id='filter_displays' onkeyup="filterText('display');" placeholder='Filter Displays:' title='Filter' style="margin-bottom: 5px;">
            </div>
            <div class="well scroller display_well">
                <div class='row'>
                    <c:choose>
                        <c:when test="${not empty displayList}">
                            <c:set var="count" value="0" scope="page" />
                            <c:forEach var="display" items="${displayList}">
                                <c:set var="count" value="${count + 1}" scope="page"/>
                                <div id="display_${count}"
                                     draggable='false'
                                     droppable='true'
                                     ondragover='allowDrop(event)'
                                     ondrop='dropped(event)'
                                     ondragleave='leave(event)'
                                     ondblclick='dbl_clicked(event,"${display.getIpAddress()}")'
                                     uid = "${display.getName()}"
                                     class='display no_select thumbnail col-xs-6 col-md-2 col-sm-3'
                                     name="${display.getDisplayName()}" >
                                    <img id='d_img_${count}'
                                         thumb="http://${display.getIpAddress()}/thumb.jpg"
                                         alt='Display'
                                         class='display_img no_select'
                                         src='../images/novideo.png'
                                         onerror="this.src='../images/novideo.png';">
                                    <div style='text-align:center;' class='caption no_event'>
                                        <p class='stext'>${display.getDisplayName()}</p>
                                    </div>
                                </div><!-- display div end -->
                            </c:forEach>
                        </c:when>
                        <c:otherwise>
                            <br>
                            <div class="alert alert-info">
                                No endpoints found matching your search criteria
                            </div>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div> <!-- display dev well-scroller -->
        </div>
        <!-- Modals follow -->

        <!-- editPreset Modal -->
        <div class="container">
            <!-- Modal -->
            <div class="modal fade" id="editPresetModal" role="dialog">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content" id="editPresetModalDialog">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Edit Preset</h4>
                        </div>
                        <div class="modal-body" id="editPresetModalBody">
                            <table style="width: 100%; table-layout: fixed;">
                                <tr>
                                    <td class="editPresetTable">Preset Index</td>
                                    <td class="editPresetTable">Preset Name</td>
                                </tr>
                                <tr>
                                    <td>
                                        <select class='select pull-left' id="editPresetIndex">
                                            <c:forEach var="i" begin = "1" end = "999">
                                            <option value="<fmt:formatNumber minIntegerDigits='3' value='${i}' />"><fmt:formatNumber minIntegerDigits='3' value='${i}' /></option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                    <td class="editPresetTable"><input id="editPresetName" type="text" value="New_Preset" title="Letters, numbers, dashes and underscores only" style="width: 100%;"></td>
                                </tr>
                            </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary pull-left" onclick="delete_preset();">Delete</button>
                            <button type="button" class="btn btn-primary" onclick="new_preset();">Update</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- container -->
        <!-- End editPreset Modal -->

        <!-- SavePreset Modal -->
        <div class="container">
            <!-- Modal -->
            <div class="modal fade" id="savePresetModal" role="dialog">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content" id="savePresetModalDialog">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Save Preset</h4>
                        </div>
                        <div class="modal-body" id="savePresetModalBody">
                            <select class='select' id="savePresetIndex">
                                <c:forEach var="preset" items="${presetList}">
                                    <option value="${preset.getIndex()}" name="${preset.getName()}">${preset.getIndex()}-${preset.getName()}</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" onclick="save_preset();">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- container -->
        <!-- End SavePreset Modal -->

        <!-- RecallPreset Modal -->
        <div class="container">
            <!-- Modal -->
            <div class="modal fade" id="recallPresetModal" role="dialog">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content" id="recallPresetModalDialog">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Recall Preset</h4>
                        </div>
                        <div class="modal-body" id="recallPresetModalBody">
                            <select class='select' id="recallPresetIndex">
                            <c:forEach var="preset" items="${presetList}">
                                <option value="${preset.getIndex()}">${preset.getIndex()}-${preset.getName()}</option>
                            </c:forEach>
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" onclick="recall_preset(document.getElementById('recallPresetIndex').value);">Recall</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- container -->
        <!-- End RecallPreset Modal -->
    </body>
</html>
