/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.util.ExceptionUtils;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    private final Log log;
    private JspCompilationContext ctxt;
    private PageInfo pi;
    private ErrorDispatcher err;
    private ParserController parserController;
    protected TagLibraryValidator tagLibraryValidator;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", "" + this.tagLibraryValidator, out);
        for (i = 0; i < this.tags.length; ++i) {
            out.println(this.tags[i].toString());
        }
        for (i = 0; i < this.tagFiles.length; ++i) {
            out.println(this.tagFiles[i].toString());
        }
        for (i = 0; i < this.functions.length; ++i) {
            out.println(this.functions[i].toString());
        }
        return sw.toString();
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        if (uri.startsWith("file:")) {
            return new FileInputStream(new File(uri.substring(5)));
        }
        try {
            String real = this.ctxt.getRealPath(uri);
            if (real == null) {
                return this.ctxt.getResourceAsStream(uri);
            }
            return new FileInputStream(real);
        }
        catch (FileNotFoundException ex) {
            return this.ctxt.getResourceAsStream(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagLibraryInfoImpl(JspCompilationContext ctxt, ParserController pc, PageInfo pi, String prefix, String uriIn, TldLocation location, ErrorDispatcher err, Mark mark) throws JasperException {
        block16: {
            super(prefix, uriIn);
            this.log = LogFactory.getLog(TagLibraryInfoImpl.class);
            this.ctxt = ctxt;
            this.parserController = pc;
            this.pi = pi;
            this.err = err;
            InputStream in = null;
            if (location == null) {
                location = this.generateTLDLocation(this.uri, ctxt);
            }
            String tldName = location.getName();
            JarResource jarResource = location.getJarResource();
            try {
                if (jarResource == null) {
                    try {
                        in = this.getResourceAsStream(tldName);
                        if (in == null) {
                            throw new FileNotFoundException(tldName);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        err.jspError(mark, "jsp.error.file.not.found", tldName);
                    }
                    this.parseTLD(tldName, in, null);
                    PageInfo pageInfo = ctxt.createCompiler().getPageInfo();
                    if (pageInfo != null) {
                        pageInfo.addDependant(tldName, ctxt.getLastModified(tldName));
                    }
                    break block16;
                }
                try {
                    in = jarResource.getEntry(tldName).openStream();
                    this.parseTLD(jarResource.getUrl(), in, jarResource);
                }
                catch (Exception ex) {
                    err.jspError(mark, "jsp.error.tld.unable_to_read", jarResource.getUrl(), tldName, ex.toString());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
            }
        }
    }

    @Override
    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> coll = this.pi.getTaglibs();
        return coll.toArray(new TagLibraryInfo[0]);
    }

    private void parseTLD(String uri, InputStream in, JarResource jarResource) throws JasperException {
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        Vector<TagFileInfo> tagFileVector = new Vector<TagFileInfo>();
        Hashtable<String, FunctionInfo> functionTable = new Hashtable<String, FunctionInfo>();
        ServletContext servletContext = this.ctxt.getServletContext();
        boolean validate = Boolean.parseBoolean(servletContext.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        String blockExternalString = servletContext.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
        ParserUtils pu = new ParserUtils(validate, blockExternal);
        TreeNode tld = pu.parseXMLDocument(uri, in);
        this.jspversion = tld.findAttribute("version");
        Iterator<TreeNode> list = tld.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("tlibversion".equals(tname) || "tlib-version".equals(tname)) {
                this.tlibversion = element.getBody();
                continue;
            }
            if ("jspversion".equals(tname) || "jsp-version".equals(tname)) {
                this.jspversion = element.getBody();
                continue;
            }
            if ("shortname".equals(tname) || "short-name".equals(tname)) {
                this.shortname = element.getBody();
                continue;
            }
            if ("uri".equals(tname)) {
                this.urn = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                this.info = element.getBody();
                continue;
            }
            if ("validator".equals(tname)) {
                this.tagLibraryValidator = this.createValidator(element);
                continue;
            }
            if ("tag".equals(tname)) {
                tagVector.addElement(this.createTagInfo(element, this.jspversion));
                continue;
            }
            if ("tag-file".equals(tname)) {
                TagFileInfo tagFileInfo = this.createTagFileInfo(element, jarResource);
                tagFileVector.addElement(tagFileInfo);
                continue;
            }
            if ("function".equals(tname)) {
                FunctionInfo funcInfo = this.createFunctionInfo(element);
                String funcName = funcInfo.getName();
                if (functionTable.containsKey(funcName)) {
                    this.err.jspError("jsp.error.tld.fn.duplicate.name", funcName, uri);
                }
                functionTable.put(funcName, funcInfo);
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "listener".equals(tname) || "taglib-extension".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.taglib", tname));
        }
        if (this.tlibversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "tlib-version", uri);
        }
        if (this.jspversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "jsp-version", uri);
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
        this.tagFiles = new TagFileInfo[tagFileVector.size()];
        tagFileVector.copyInto(this.tagFiles);
        this.functions = new FunctionInfo[functionTable.size()];
        int i = 0;
        Enumeration enumeration = functionTable.elements();
        while (enumeration.hasMoreElements()) {
            this.functions[i++] = (FunctionInfo)enumeration.nextElement();
        }
    }

    private TldLocation generateTLDLocation(String uri, JspCompilationContext ctxt) throws JasperException {
        int uriType = TldLocationsCache.uriType(uri);
        if (uriType == 0) {
            this.err.jspError("jsp.error.taglibDirective.absUriCannotBeResolved", uri);
        } else if (uriType == 2) {
            uri = ctxt.resolveRelativeUri(uri);
        }
        if (uri.endsWith(".jar")) {
            URL url = null;
            try {
                url = ctxt.getResource(uri);
            }
            catch (Exception ex) {
                this.err.jspError("jsp.error.tld.unable_to_get_jar", uri, ex.toString());
            }
            if (url == null) {
                this.err.jspError("jsp.error.tld.missing_jar", uri);
            }
            return new TldLocation("META-INF/taglib.tld", url.toString());
        }
        return new TldLocation(uri);
    }

    private TagInfo createTagInfo(TreeNode elem, String jspVersion) throws JasperException {
        String tagName = null;
        String tagClassName = null;
        String teiClassName = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        boolean dynamicAttributes = false;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> variableVector = new Vector<TagVariableInfo>();
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                tagName = element.getBody();
                continue;
            }
            if ("tagclass".equals(tname) || "tag-class".equals(tname)) {
                tagClassName = element.getBody();
                continue;
            }
            if ("teiclass".equals(tname) || "tei-class".equals(tname)) {
                teiClassName = element.getBody();
                continue;
            }
            if ("bodycontent".equals(tname) || "body-content".equals(tname)) {
                bodycontent = element.getBody();
                continue;
            }
            if ("display-name".equals(tname)) {
                displayName = element.getBody();
                continue;
            }
            if ("small-icon".equals(tname)) {
                smallIcon = element.getBody();
                continue;
            }
            if ("large-icon".equals(tname)) {
                largeIcon = element.getBody();
                continue;
            }
            if ("icon".equals(tname)) {
                TreeNode icon = element.findChild("small-icon");
                if (icon != null) {
                    smallIcon = icon.getBody();
                }
                if ((icon = element.findChild("large-icon")) == null) continue;
                largeIcon = icon.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                info = element.getBody();
                continue;
            }
            if ("variable".equals(tname)) {
                variableVector.addElement(this.createVariable(element));
                continue;
            }
            if ("attribute".equals(tname)) {
                attributeVector.addElement(this.createAttribute(element, jspVersion));
                continue;
            }
            if ("dynamic-attributes".equals(tname)) {
                dynamicAttributes = JspUtil.booleanValue(element.getBody());
                continue;
            }
            if ("example".equals(tname) || "tag-extension".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.tag", tname));
        }
        TagExtraInfo tei = null;
        if (teiClassName != null && !teiClassName.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiClassName);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError(e, "jsp.error.teiclass.instantiation", teiClassName);
            }
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        Object[] tagVariableInfos = new TagVariableInfo[variableVector.size()];
        variableVector.copyInto(tagVariableInfos);
        TagInfo taginfo = new TagInfo(tagName, tagClassName, bodycontent, info, this, tei, (TagAttributeInfo[])tagAttributeInfo, displayName, smallIcon, largeIcon, (TagVariableInfo[])tagVariableInfos, dynamicAttributes);
        return taginfo;
    }

    private TagFileInfo createTagFileInfo(TreeNode elem, JarResource jarResource) throws JasperException {
        String name = null;
        String path = null;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode child = list.next();
            String tname = child.getName();
            if ("name".equals(tname)) {
                name = child.getBody();
                continue;
            }
            if ("path".equals(tname)) {
                path = child.getBody();
                continue;
            }
            if ("example".equals(tname) || "tag-extension".equals(tname) || "icon".equals(tname) || "display-name".equals(tname) || "description".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.tagfile", tname));
        }
        if (path.startsWith("/META-INF/tags")) {
            this.ctxt.setTagFileJarResource(path, jarResource);
        } else if (!path.startsWith("/WEB-INF/tags")) {
            this.err.jspError("jsp.error.tagfile.illegalPath", path);
        }
        TagInfo tagInfo = TagFileProcessor.parseTagFileDirectives(this.parserController, name, path, jarResource, this);
        return new TagFileInfo(name, path, tagInfo);
    }

    TagAttributeInfo createAttribute(TreeNode elem, String jspVersion) {
        String name = null;
        String type = null;
        String expectedType = null;
        String methodSignature = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean isFragment = false;
        boolean deferredValue = false;
        boolean deferredMethod = false;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode child;
            String s;
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("required".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                required = JspUtil.booleanValue(s);
                continue;
            }
            if ("rtexprvalue".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                rtexprvalue = JspUtil.booleanValue(s);
                continue;
            }
            if ("type".equals(tname)) {
                type = element.getBody();
                if (!"1.2".equals(jspVersion) || !type.equals("Boolean") && !type.equals("Byte") && !type.equals("Character") && !type.equals("Double") && !type.equals("Float") && !type.equals("Integer") && !type.equals("Long") && !type.equals("Object") && !type.equals("Short") && !type.equals("String")) continue;
                type = "java.lang." + type;
                continue;
            }
            if ("fragment".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                isFragment = JspUtil.booleanValue(s);
                continue;
            }
            if ("deferred-value".equals(tname)) {
                deferredValue = true;
                type = "javax.el.ValueExpression";
                child = element.findChild("type");
                if (child != null) {
                    expectedType = child.getBody();
                    if (expectedType == null) continue;
                    expectedType = expectedType.trim();
                    continue;
                }
                expectedType = "java.lang.Object";
                continue;
            }
            if ("deferred-method".equals(tname)) {
                deferredMethod = true;
                type = "javax.el.MethodExpression";
                child = element.findChild("method-signature");
                if (child != null) {
                    methodSignature = child.getBody();
                    if (methodSignature == null) continue;
                    methodSignature = methodSignature.trim();
                    continue;
                }
                methodSignature = "java.lang.Object method()";
                continue;
            }
            if ("description".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.attribute", tname));
        }
        if (isFragment) {
            type = "javax.servlet.jsp.tagext.JspFragment";
            rtexprvalue = true;
        }
        if (!rtexprvalue && type == null) {
            type = "java.lang.String";
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue, isFragment, null, deferredValue, deferredMethod, expectedType, methodSignature);
    }

    TagVariableInfo createVariable(TreeNode elem) {
        String nameGiven = null;
        String nameFromAttribute = null;
        String className = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            String s;
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name-given".equals(tname)) {
                nameGiven = element.getBody();
                continue;
            }
            if ("name-from-attribute".equals(tname)) {
                nameFromAttribute = element.getBody();
                continue;
            }
            if ("variable-class".equals(tname)) {
                className = element.getBody();
                continue;
            }
            if ("declare".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                declare = JspUtil.booleanValue(s);
                continue;
            }
            if ("scope".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                if ("NESTED".equals(s)) {
                    scope = 0;
                    continue;
                }
                if ("AT_BEGIN".equals(s)) {
                    scope = 1;
                    continue;
                }
                if (!"AT_END".equals(s)) continue;
                scope = 2;
                continue;
            }
            if ("description".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.variable", tname));
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope);
    }

    private TagLibraryValidator createValidator(TreeNode elem) throws JasperException {
        String validatorClass = null;
        Hashtable<String, Object> initParams = new Hashtable<String, Object>();
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("validator-class".equals(tname)) {
                validatorClass = element.getBody();
                continue;
            }
            if ("init-param".equals(tname)) {
                String[] initParam = this.createInitParam(element);
                initParams.put(initParam[0], initParam[1]);
                continue;
            }
            if ("description".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.validator", tname));
        }
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError(e, "jsp.error.tlvclass.instantiation", validatorClass);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    String[] createInitParam(TreeNode elem) {
        String[] initParam = new String[2];
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("param-name".equals(tname)) {
                initParam[0] = element.getBody();
                continue;
            }
            if ("param-value".equals(tname)) {
                initParam[1] = element.getBody();
                continue;
            }
            if ("description".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.initParam", tname));
        }
        return initParam;
    }

    FunctionInfo createFunctionInfo(TreeNode elem) {
        String name = null;
        String klass = null;
        String signature = null;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("function-class".equals(tname)) {
                klass = element.getBody();
                continue;
            }
            if ("function-signature".equals(tname)) {
                signature = element.getBody();
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "description".equals(tname) || "example".equals(tname) || !this.log.isWarnEnabled()) continue;
            this.log.warn(Localizer.getMessage("jsp.warning.unknown.element.in.function", tname));
        }
        return new FunctionInfo(name, klass, signature);
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        String uri = this.getURI();
        if (uri.startsWith("/")) {
            uri = "urn:jsptld:" + uri;
        }
        return tlv.validate(this.getPrefixString(), uri, thePage);
    }
}

