/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.PresetList;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Preset
implements Serializable {
    private String name;
    private String index;
    private static final Logger logger = Logger.getLogger("Preset");
    private static final boolean debug = true;

    public static Preset getPresetByName(String presetName) {
        Predicate<Preset> presetPredicate = p -> p.getIndex().equals(presetName);
        try {
            Preset obj = PresetList.getInstance().stream().filter(presetPredicate).findFirst().get();
            return obj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Preset getPresetByIndex(String presetIndex) {
        Predicate<Preset> presetPredicate = p -> p.getIndex().equals(presetIndex);
        try {
            Preset obj = PresetList.getInstance().stream().filter(presetPredicate).findFirst().get();
            return obj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Preset createOrGetPreset(String presetIndex, String presetName) {
        logger.log(Level.FINEST, MessageFormat.format("createOrGetPreset Index: {0} Name: {1}", presetIndex, presetName));
        if ("".equals(presetIndex)) {
            return null;
        }
        Preset preset = Preset.getPresetByIndex(presetIndex);
        if (preset == null) {
            if (presetIndex.matches("^(00[1-9]|0[1-9][0-9]|[1-9][0-9][0-9])$")) {
                preset = new Preset(presetIndex, presetName);
                logger.log(Level.FINEST, MessageFormat.format("createOrGetPreset toString: {0}", preset.toString()));
                logger.log(Level.FINEST, MessageFormat.format("Created Preset Index: {0} Name: {1}", presetIndex, presetName));
                PresetList.addPreset(preset);
            } else {
                logger.log(Level.FINEST, MessageFormat.format("createOrGetPreset Error improper index: ", presetIndex));
                return null;
            }
        }
        return preset;
    }

    private Preset(String presetIndex, String presetName) {
        this.name = presetName;
        this.index = presetIndex;
        logger.log(Level.FINEST, MessageFormat.format("Preset Index: {0} Name: {1}", this.index, this.name));
    }

    public Preset() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndex() {
        return this.index;
    }

    public String toString() {
        String str = "Preset{ index=" + this.getIndex() + " name=" + this.getName() + '}';
        logger.log(Level.FINEST, MessageFormat.format("toString: {0}", str));
        return str;
    }

    static {
        logger.setLevel(Level.FINEST);
    }
}

