/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointList;
import com.vsiptv.VLite.Group;
import com.vsiptv.VLite.NetworkService;
import com.vsiptv.VLite.VideoWall;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class EndpointService {
    private static final Logger logger = Logger.getLogger("NetworkService");
    private static final Boolean debug = false;
    private int discoveredEncoderCount = 0;
    private List<String> modelList = new ArrayList<String>();
    private int discoveredDecoderCount = 0;
    private List<Endpoint> endpointList = EndpointList.getInstance();
    private int invalidCount;
    private int unvisifiedCount;
    private int emu = 0;
    private static final String USER_AGENT = "Mozilla/5.0";

    public List<Endpoint> discoverEndpoints() throws IOException {
        int port = 8000;
        String group = "226.1.2.20";
        int ttl = 64;
        int packets_r = 0;
        boolean j = false;
        ArrayList requery_list = new ArrayList();
        HashMap<String, String> unit_list_original = new HashMap<String, String>();
        HashMap unit_list_temp = new HashMap();
        HashMap unit_list_final = new HashMap();
        this.endpointList.clear();
        Group.clear();
        this.discoveredEncoderCount = 0;
        this.discoveredDecoderCount = 0;
        this.invalidCount = 0;
        this.unvisifiedCount = 0;
        packets_r = 0;
        String apiCommand = "CMD=START&UNIT.ID=NONE&QUERY.ALL=TRUE&CMD=END";
        byte[] apiCommandBuffer = apiCommand.getBytes();
        InetAddress addl = InetAddress.getByName(group);
        DatagramPacket packl = new DatagramPacket(apiCommandBuffer, apiCommandBuffer.length, addl, port);
        logger.log(Level.INFO, "Trying to discover units");
        try (MulticastSocket socket = new MulticastSocket(null);){
            String r_ip;
            socket.setSoTimeout(3200);
            socket.setNetworkInterface(NetworkService.getSelectedNetworkInterface().getNetworkInterface());
            InetAddress inetAddress = (InetAddress)NetworkService.getSelectedNetworkInterface().getInetAddress();
            InetSocketAddress saddr = new InetSocketAddress(inetAddress, 0);
            socket.bind(saddr);
            socket.setTimeToLive(ttl);
            if (debug.booleanValue()) {
                logger.log(Level.FINEST, "MCAST_SOCKET getInetAddress(): {0}", socket.getInetAddress());
                logger.log(Level.FINEST, "MCAST_SOCKET getLocalSocketAddress(): {0}", socket.getLocalSocketAddress());
                logger.log(Level.FINEST, "MCAST_SOCKET getInterface(): {0}", socket.getInterface());
                logger.log(Level.FINEST, "MCAST_SOCKET getNetworkInterface(): {0}", socket.getNetworkInterface());
                logger.log(Level.FINEST, "MCAST_SOCKET try bind: {0}", saddr);
            }
            socket.send(packl);
            Thread.sleep(320L);
            socket.send(packl);
            Thread.sleep(320L);
            apiCommand = "CMD=START&UNIT.ID=ALL&QUERY.ALL=TRUE&CMD=END";
            apiCommandBuffer = apiCommand.getBytes();
            InetAddress address = InetAddress.getByName(group);
            DatagramPacket packet = new DatagramPacket(apiCommandBuffer, apiCommandBuffer.length, address, port);
            socket.send(packet);
            boolean done = false;
            this.invalidCount = 0;
            this.unvisifiedCount = 0;
            while (!done) {
                byte[] apiResponseBuffer = new byte[1500];
                DatagramPacket apiResponse = new DatagramPacket(apiResponseBuffer, apiResponseBuffer.length);
                try {
                    socket.receive(apiResponse);
                }
                catch (SocketTimeoutException ex) {
                    done = true;
                    continue;
                }
                ++packets_r;
                String data = new String(apiResponse.getData(), "UTF-8");
                data = data.trim();
                logger.log(Level.INFO, "Endpoint Data: {0}", data);
                r_ip = apiResponse.getAddress().getHostAddress();
                if (unit_list_original.containsKey(r_ip)) {
                    String tdata = (String)unit_list_original.get(r_ip);
                    tdata = tdata + data;
                    unit_list_original.put(r_ip, tdata);
                    continue;
                }
                unit_list_original.put(r_ip, data);
            }
            logger.log(Level.INFO, "Packets Received: {0}", packets_r);
            logger.log(Level.INFO, "Valid Units Found: {0}", unit_list_original.size());
            r_ip = "127.128.129.130";
            logger.log(Level.INFO, "r_ip: {0}", r_ip);
            for (Map.Entry pdata : unit_list_original.entrySet()) {
                String data = (String)pdata.getValue();
                int len = data.length();
                logger.log(Level.INFO, MessageFormat.format("Key: {0} Len: {1}\n Val: {2}", r_ip, len, data));
                Map<String, String> parameterMap = this.parameterMapFromData(data);
                String serial = parameterMap.get("UNIT.SERIAL");
                logger.log(Level.INFO, "UNIT.SERIAL: {0}", serial);
                if (this.searchEndpointsByName(serial).isEmpty()) {
                    logger.log(Level.INFO, "Inside Main Add Loop: {0}", parameterMap.get("UNIT.ID"));
                    Endpoint endpoint = Endpoint.createFromParameterMap(parameterMap);
                    logger.log(Level.FINEST, "JCC New Endpoint - UNIT.ID : {0}", parameterMap.get("UNIT.ID"));
                    logger.log(Level.INFO, "Inside Main Add Loop: {0}", endpoint);
                    if (endpoint != null) {
                        Group vw;
                        this.addEndpoint(endpoint);
                        if (endpoint.getVwName() == null || !endpoint.getVwIsEnabled().booleanValue() || !((vw = VideoWall.createOrGetGroup(endpoint.getVwName())) instanceof VideoWall)) continue;
                        ((VideoWall)vw).addEndpoint(endpoint);
                        logger.log(Level.FINEST, MessageFormat.format("{0} added to VideoWall {1}", parameterMap.get("UNIT.ID"), endpoint.getVwName()));
                        continue;
                    }
                    logger.log(Level.INFO, "Invalid Endpoint Name: {0}", serial);
                    ++this.invalidCount;
                    continue;
                }
                logger.log(Level.INFO, "Endpoint Name Already Present: {0}", serial);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(EndpointService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.getSortedEndpoints();
    }

    private String sendAPICommand(String cmd, String ip) {
        String data = null;
        try {
            byte[] apiCommandBuffer = cmd.getBytes();
            int port = 8000;
            byte[] bytes = new byte[4];
            InetAddress add1 = InetAddress.getByAddress(bytes);
            try (DatagramSocket socket = new DatagramSocket();){
                InetAddress address = InetAddress.getByName(ip);
                DatagramPacket pack = new DatagramPacket(apiCommandBuffer, apiCommandBuffer.length, address, port);
                socket.setSoTimeout(1000);
                socket.send(pack);
                byte[] apiResponseBuffer = new byte[1500];
                DatagramPacket apiResponse = new DatagramPacket(apiResponseBuffer, apiResponseBuffer.length);
                try {
                    socket.receive(apiResponse);
                    add1 = apiResponse.getAddress();
                }
                catch (SocketTimeoutException ex) {
                    System.out.println(ex);
                }
                data = new String(apiResponse.getData());
                logger.log(Level.FINEST, "apiResponse.getData(): {0} Address: {1}", new Object[]{data, add1.getHostAddress()});
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Endpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
        return data;
    }

    private void sendAPICommandFast(String cmd, String ip, DatagramSocket socket) {
        Object data = null;
        try {
            byte[] apiCommandBuffer = cmd.getBytes();
            int port = 8000;
            try {
                InetAddress address = InetAddress.getByName(ip);
                DatagramPacket pack = new DatagramPacket(apiCommandBuffer, apiCommandBuffer.length, address, port);
                socket.send(pack);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Endpoint.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Map<String, String> parameterMapFromData(String in) {
        String[] pairs = in.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs) {
            try {
                String[] keyValue = pair.split("=");
                map.put(keyValue[0], keyValue[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public List<Endpoint> getAllEndpoints() {
        Comparator<Endpoint> groupByComparator = Comparator.comparing(Group::getName);
        List<Endpoint> result = this.endpointList.stream().sorted(groupByComparator).collect(Collectors.toList());
        return result;
    }

    public List<Endpoint> getSortedEndpoints() {
        Comparator<Endpoint> groupByComparator = Comparator.comparing(Endpoint::getModel).reversed().thenComparing(Group::getName);
        List<Endpoint> result = this.endpointList.stream().sorted(groupByComparator).collect(Collectors.toList());
        return result;
    }

    public List<Group> getSortedDisplays() {
        Comparator<Group> nameComparator = Comparator.comparing(Group::getName);
        Predicate<Group> isDisplayPredicate = g -> g.isDisplay();
        List<Group> result = Group.getGroupList().stream().filter(isDisplayPredicate).sorted(nameComparator).collect(Collectors.toList());
        return result;
    }

    public List<Endpoint> searchEndpointsByName(String name) {
        Comparator<Endpoint> groupByComparator = Comparator.comparing(Group::getName).thenComparing(Endpoint::getModel);
        List<Endpoint> result = this.endpointList.stream().filter(e -> e.getName().equalsIgnoreCase(name)).sorted(groupByComparator).collect(Collectors.toList());
        return result;
    }

    public List<Endpoint> searchEndpointsBySerial(String serial) {
        Comparator<Endpoint> groupByComparator = Comparator.comparing(Endpoint::getSerialNumber).thenComparing(Endpoint::getModel);
        List<Endpoint> result = this.endpointList.stream().filter(e -> e.getSerialNumber().equalsIgnoreCase(serial)).sorted(groupByComparator).collect(Collectors.toList());
        return result;
    }

    public Endpoint getEndpointByName(String id) throws Exception {
        Optional<Endpoint> match = this.endpointList.stream().filter(e -> e.getId().equals(id)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new Exception("The Endpoint id " + id + " not found");
    }

    public Endpoint getEndpointBySerial(String serial) throws Exception {
        Optional<Endpoint> match = this.endpointList.stream().filter(e -> e.getSerialNumber().equals(serial)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new Exception("The Endpoint serial " + serial + " not found");
    }

    public Endpoint getEndpointByMacAddress(String macAddress) throws Exception {
        Optional<Endpoint> match = this.endpointList.stream().filter(e -> e.getMacAddress().equals(macAddress)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new Exception("The Endpoint with macAddress " + macAddress + " not found");
    }

    public Endpoint getEndpointByIPAddress(String ipAddress) throws Exception {
        Optional<Endpoint> match = this.endpointList.stream().filter(e -> e.getIpAddress().equals(ipAddress)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new Exception("The Endpoint with IP Address " + ipAddress + " not found");
    }

    public Group getDisplayByUniqueName(String uniqueName) throws Exception {
        Optional<Group> match = Group.getGroupList().stream().filter(e -> e.getName().equals(uniqueName)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new Exception("The Display named " + uniqueName + "was not found");
    }

    public boolean addEndpoint(Endpoint endpoint) {
        this.endpointList.add(endpoint);
        if (endpoint.isEncoder()) {
            ++this.discoveredEncoderCount;
        } else if (endpoint.isDecoder()) {
            ++this.discoveredDecoderCount;
        }
        this.modelList.add(endpoint.getModel());
        return true;
    }

    public boolean updateEndpoint(Endpoint endpoint) {
        logger.log(Level.FINEST, "Endpoint: {0}", endpoint.toString());
        Optional<Endpoint> match = this.endpointList.stream().filter(c -> c.getMacAddress().equals(endpoint.getMacAddress())).findFirst();
        if (match.isPresent()) {
            int matchIdx = this.endpointList.indexOf(match.get());
            this.endpointList.set(matchIdx, endpoint);
            return true;
        }
        return false;
    }

    public boolean deleteEndpoint(String name) {
        Predicate<Endpoint> endpoint = e -> e.getName().equals(name);
        return this.endpointList.removeIf(endpoint);
    }

    public boolean firmwareUpdateEndpoint(Endpoint endpoint) {
        String url = "http://" + endpoint.getIpAddress();
        try {
            this.sendGET(url);
        }
        catch (Exception ex) {
            System.out.println("GET error :: " + ex);
        }
        return true;
    }

    private void sendGET(String url) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", USER_AGENT);
        int responseCode = con.getResponseCode();
        logger.log(Level.FINEST, "GET Response Code :: {0}", responseCode);
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            logger.log(Level.FINEST, response.toString());
        } else {
            logger.log(Level.FINEST, "GET request did not work");
        }
    }

    private void sendPOST(String url, File file) throws IOException {
        int bytesRead;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        int responseCode = con.getResponseCode();
        logger.log(Level.FINEST, "POST Response Code :: {0}", responseCode);
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            logger.log(Level.FINEST, response.toString());
        } else {
            logger.log(Level.FINEST, "POST request failed");
        }
    }

    public String encoderCount() {
        String ec = Integer.toString(this.discoveredEncoderCount);
        return ec;
    }

    public String modelCount(String model) {
        Integer mc = Collections.frequency(this.modelList, model);
        return mc.toString();
    }

    public String decoderCount() {
        String ed = Integer.toString(this.discoveredDecoderCount);
        return ed;
    }

    public int invalidCount() {
        return this.invalidCount;
    }

    public int unvisifiedCount() {
        return this.unvisifiedCount;
    }

    public static int ordinalIndexOf(String str, String substr, int n) {
        int pos = -1;
        do {
            pos = str.indexOf(substr, pos + 1);
        } while (n-- > 0 && pos != -1);
        return pos;
    }

    static {
        logger.setLevel(Level.FINEST);
    }

    public class ssPair {
        private String k;
        private String v;

        private ssPair(String key, String val) {
            this.k = key;
            this.v = val;
        }

        public String getK() {
            return this.k;
        }

        public String getV() {
            return this.v;
        }
    }
}

