<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <script src="../js/jquery.min.js"></script>
        <link rel="stylesheet" href="../css/bootstrap.min.css">
        <link rel="stylesheet" href="../css/VLite.css">
        <link rel="stylesheet" href="../css/signin.css">
        <script src="../js/bootstrap.min.js"></script>
        <script>
            var ctu_counts = 1; // Login page update timer
            function configTextUpdate()
            {
                var ta = document.getElementById('status_textarea');
                ta.textContent = "Discovering Units " + ctu_counts;
                ctu_counts = ctu_counts + 1;
                if(ctu_counts < 32)
                {
                    setTimeout(configTextUpdate, 1000);
                }
                else
                {
                    ctu_counts = 1;
                }
            }
        </script>
    </head>

    <body>
        <!-- Navigation -->
        <jsp:include page="navtop.jsp"/>
        <!-- END Navigation -->

        <div class="container">

            <form class="form-signin" action="/login" method="post" onsubmit="return configTextUpdate();">
                <input type="hidden" name="action" value="login" />
                <h2 class="form-signin-heading">${pString} Login</h2>
                <label for="inputUser" class="sr-only">Username</label>
                <input type="user" name="user" id="inputUser" class="form-control" placeholder="Username" required autofocus>
                <label for="inputPassword" class="sr-only">Password</label>
                <input type="password" name="pass" id="inputPassword" class="form-control" placeholder="Password" required>
                <button class="btn btn-lg btn-primary btn-block" type="submit">Login</button>
                <h2>Status</h2>
                <textarea class='form-control' id='status_textarea' rows='5' style='resize:none;' readonly >Status Information</textarea>
            </form>

        </div> <!-- /container -->




    </body>
</html>