<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
    <head>
        <script src="../js/jquery.min.js"></script>
        <link rel="stylesheet" href="../css/bootstrap.min.css">
        <link rel="stylesheet" href="../css/VLite.css">
        <script src="../js/bootstrap.min.js"></script>

        <script>
        // Javascript backend calls for Vision Lite config
        // Copyright 2011-2017 Visionary Solutions, Inc.

        "use strict";

        var initted = false;

        var jcc_alerts = true;  // Turn on or off my alerts

        var interval = 1000;  // Basic update time in milliseconds
        var hrefs = [];  // Temp HREF storage array
        var onclks = [];  // Temp onClick storage array
        var ctu_counts = 1; // Config page update timer
        var sortingTimer=0;  // Use to stop the sorting messages
        var dir_unit=[]; // Direction for sorting
        var dir_text;
        var filtered_count;  // Used to show how many items match the filter


        // Private functions

        window.onload = function() {
            init();
        };

        function init()
        {
            var d = new Date();
            var ta = document.getElementById('status_textarea');
            update_text(ta, "Updated: " + d);
            initted = true;
        }

        function jcc_alert(o)
        {
            if (jcc_alerts)
            {
                alert(o);
            }
        }

        function disable_all()
        {
        var inputs = document.getElementsByTagName('input');
        var refs;
          for (var i = 0; i < inputs.length; i++)
          {
            if(inputs[i].type === 'submit')
            {
              inputs[i].disabled = true;
            }
            if(inputs[i].type === 'button')
            {
              inputs[i].disabled = true;
            }
          }
          refs = document.links;
          for (var i = 0; i < refs.length; i++)
          {
            hrefs[i] = refs[i].href;  // Store for use by enable_all
            onclks[i] = refs[i].onclick;  // Store for use by enable_all
            refs[i].href = "javascript: void(0)";
            refs[i].onclick = "";  // Null out the on click
          }
        }

        function enable_all()
        {
        var inputs = document.getElementsByTagName('input');
        var refs;
          for (var i = 0; i < inputs.length; i++)
          {
            if(inputs[i].type === 'submit')
            {
              inputs[i].disabled = false;
            }
            if(inputs[i].type === 'button')
            {
              inputs[i].disabled = false;
            }
          }
          refs = document.links;
          for (var i = 0; i < refs.length; i++)
          {
            refs[i].href = hrefs[i];
            refs[i].onclick = onclks[i];
          }
        }

        function updateEndpoints()
        {
            var cb;
            var cbs;
            var ta;
            var temp;
            var count=0;
            var params="";

            ta = document.getElementById('status_textarea');


            if(confirm("Are you sure you want to perform a firmware update?"))
            {
            }
            else
            {
                update_text(ta, 'Update Cancelled.');
                return;
            }
            document.getElementById('updateButton').disabled = true;
            cbs = document.getElementsByName('update');
            for (cb of cbs)
            {
                if(cb.checked === true)
                {
                    $("#update_success_alert").hide();
                    $("#update_danger_alert").show();
                    count = count + 1;
                    params += "&uid_"+ count + "=" + cb.getAttribute('uid');
                }
            }
            sendUpdate(params, count);

            // update the progress bar to resemble update progress
            var progress_value = 0;
            var interval = setInterval( function() {
                progress_value += 1;
                $("#progress-bar")
                        .css("width", progress_value + "%")
                        .attr("aria-valuenow", progress_value)
                        .text(progress_value + "%");
                if (progress_value >= 100) {
                    clearInterval(interval);
                    // fade out the progress bar; upon completion fadeIn success
                    $("#update_danger_alert").fadeOut(500, function(){
                        $("#update_success_alert").fadeIn('slow');
                    });
                }
            }, 4*(600)); // 600 counts per minute, so 4 minutes
        }

        function defaultEndpoints()
        {
            var cb;
            var cbs;
            var ta;
            var temp;
            var count=1;

            ta = document.getElementById('status_textarea');


            if(confirm("Are you sure you want to perform a factory default?"))
            {
            }
            else
            {
                update_text(ta, 'Default Cancelled.');
                return;
            }
            document.getElementById('defaultButton').disabled = true;
            cbs = document.getElementsByName('default');
            for (cb of cbs)
            {
                if(cb.checked === true)
                {
                    $("#default_success_alert").hide();
                    $("#default_danger_alert").show();
                    sendDefault(cb, count);
                    count = count + 1;
                }
            }

            // update the progress bar to resemble default progress
            var progress_value = 0;
            var interval = setInterval( function() {
                progress_value += 1;
                $("#d-progress-bar")
                        .css("width", progress_value + "%")
                        .attr("aria-valuenow", progress_value)
                        .text(progress_value + "%");
                if (progress_value >= 100) {
                    clearInterval(interval);
                    // fade out the progress bar; upon completion fadeIn success
                    $("#default_danger_alert").fadeOut(500, function(){
                        $("#default_success_alert").fadeIn('slow');
                    });
                }
            }, 1400); // 1.4-second interval (x100 ~ 2 minutes)
        }

        function addGroup()
        {
            var new_group;
            var params;

            new_group = prompt("Please enter the name of the new group");
            params = "&newGroupName=" + new_group;

            send_post("/config", "action=addGroup", params, 1);
        }

        function addToGroup()
        {
            var group;

            group = prompt("Please enter the name of the new group");

            alert("New group is: " + group);
        }

        // Update the text in a single line textarea
        function update_text(ta, text)
        {
          //ta.innerHTML = text;
          ta.textContent = text;
        }

        function checkAllUpdate(o)
        {
            var cb;
            var cbs;
            cbs = document.getElementsByName('update');
            for (cb of cbs)
            {
                if((o.checked === true)&&( cb.parentElement.parentElement.style.display === ""))
                {
                    cb.checked = true;
                }
                else
                {
                    cb.checked = false;
                }
            }
        }

        function checkAllDefault(o)
        {
            var cb;
            var cbs;
            cbs = document.getElementsByName('default');
            for (cb of cbs)
            {
                if((o.checked === true)&&( cb.parentElement.parentElement.style.display === ""))
                {
                    cb.checked = true;
                }
                else
                {
                    cb.checked = false;
                }
            }
        }

        function sendUpdate(params, count)
        {
            //var params;

            var ta = document.getElementById('status_textarea');
            update_text(ta, ta.innerHTML + '\nUploading Firmware File(s). Count: ' + count);

            //setTimeout(function(){send_post("/config", "action=update", params, count);}, (count * 140) );
            console.log("Params: " + params);
            console.log("Count: " + count);
            params += "&count=" + count.toString();
            send_post("/config", "action=update_many", params, count);

        }

        function sendDefault(ep, count)
        {
            var params;

            var ta = document.getElementById('status_textarea');
            update_text(ta, ta.innerHTML + '\nFactory Defaulting. Count: ' + count + ' UID: ' + ep.getAttribute('uid') );
            params = "&uid=" + ep.getAttribute('uid');
            params += "&count=" + count.toString();

            setTimeout(function(){send_post("/config", "action=default", params, count);}, (count * 140) );

        }

        function get_update_info(url, params)
        {
            var xmlhttp;
            xmlhttp = new XMLHttpRequest();

            function load()
            {
                var ta = document.getElementById('info_text');
                update_text(ta, xmlhttp.responseText);
                ta.scrollTop = ta.scrollHeight - ta.clientHeight;
                timer = setTimeout("get_update_info('update_fw_info.txt', null)", 2000);
            };

            function err()
            {
                clearTimeout(timer);  // Stop the automatic updating of the info textarea
                var ta = document.getElementById('info_text').innerHTML="Unit is rebooting.";
                countdown = REBOOT_SECONDS;
                wait_for_reboot();
            };

            function to()
            {
                clearTimeout(timer);  // Stop the automatic updating of the info textarea
                var ta = document.getElementById('info_text').innerHTML="Unit is rebooting.";
                countdown = REBOOT_SECONDS;
                wait_for_reboot();
            };

            ajax(xmlhttp, 'GET', url, load, err, to, 10000, null);
        }

        function updateCount(ne, nd)
        {
            var ta;
            var temp;

            ta = document.getElementById('status_textarea');

            update_text(ta, 'Encoder Count: ' + ne + '  Decoder Count: ' + nd);
        }

        function configTextUpdate()
        {
            var ta = document.getElementById('status_textarea');
            update_text(ta, 'Discovering Units: ' + ctu_counts);
            ctu_counts = ctu_counts + 1;
            if(ctu_counts < 32)
            {
                setTimeout(configTextUpdate, 1000);
            }
            else
            {
                ctu_counts = 1;
            }
        }

        function sort_by(el)
        {
          var o1, o2;
          var tmp;
          var i=-1;
          var ipv4 = false;
          var ut = false;

          var ta = document.getElementById('status_textarea');
          o1 = document.getElementById(el);
          o2 = document.getElementById("unit_table");
          tmp = o1.id;

            if(tmp == "unit_id")
            {
                i = 0;
            }
            else if (tmp == "unit_model")
            {
                i = 1;
            }
            else if (tmp == "unit_serial")
            {
                i = 2;
            }
            else if (tmp == "unit_ip")
            {
                i = 3;
                ipv4 = true;
            }
            else if (tmp == "unit_uptime")
            {
                i = 7;
            }
            else if (tmp == "unit_location")
            {
                i = 8;
            }
            else if (tmp == "unit_fw")
            {
                i = 9;
            }
            else
            {
              alert("No item supplied");
            }
            if(i != -1)
            {
                if(dir_unit[i] == 0)
                {
                    dir_unit[i] = 1;
                    dir_text="descending";
                }
                else
                {
                    dir_unit[i]=0;
                    dir_text="ascending";
                }
                if(confirm("Sort " + o1.textContent + " in " + dir_text + " order?"))
                {
                    update_text(ta, 'Sorting');
                    setTimeout(function() {
                        sortTableFast(o2, i, ipv4, ut, dir_unit[i]);
                    }, 230)
                }
            }
        }

        function sortTableFast(tb, n, ipv4, ut, dir)
        {
            var table, rows;
            var ip1=0, ip2=0;
            var ip1t,ip2t;
            var ut1=0, ut2=0;
            var ta = document.getElementById('status_textarea');
            var table = tb;
            var type=0;

            if(ipv4 == 1)
                type = 1;
            if(ut == 1)
                type =2;

            sortRows(table, n, type, dir);

            update_text(ta, 'Sorting Done');
        }

        function sortRows(table, columnIndex, type, dir){
            var rows = table.querySelectorAll("tbody tr");
            var sel2 = "td:nth-child(" + (columnIndex + 1) + ")";
            var index;
            var node;
            const values = new Array();
            var val;
            for(index = 0; index<rows.length; index++) {
                node = rows[index].querySelector(sel2);
                val = node.innerText;
                values.push({ value: val, row: rows[index] });
            }
            if(dir == 0)
            {
                if(type == 1)
                {
                    values.sort(sortIpVal);
                }
                else if (type == 2)
                {
                    values.sort(sortNumberVal);
                }
                else
                {
                    values.sort(sortTextVal);
                }
            }
            else
            {
                if(type == 1)
                {
                    values.sort(sortIpVal);
                    values.reverse();
                }
                else if (type == 2)
                {
                    values.sort(sortNumberVal);
                    values.reverse();
                }
                else
                {
                    values.sort(sortTextVal);
                    values.reverse();
                }
            }

            for(index=0; index < values.length; index++){
                table.querySelector("tbody").appendChild(values[index].row);
            }
        }

        function sortNumberVal(a, b) {
            return sortNumber(a.value, b.value);
        }

        function sortTextVal(a, b) {
            var textA = (a.value + "").toUpperCase();
            var textB = (b.value + "").toUpperCase();
            if(textA < textB)
                return -1;
            if(textA > textB)
                return 1;
            return 0;
        }

        function sortDateVal(a, b) {
            var dateA = Date.parse(a.value);
            var dateB = Date.parse(b.value);
            return sortNumber(dateA, dateB);
        }

        function sortIpVal(a, b) {
            var textA = a.value.split('.').map ( n => +n+256 ).join('.');
            var textB = b.value.split('.').map ( n => +n+256 ).join('.');
            if(textA < textB)
                return -1;
            if(textA > textB)
                return 1;
            return 0;
        }

        function sortNumber(a, b)
        {
            return a-b;
        }

        function sortTable(tb, n, ipv4, ut)
        {
            var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
            var ip1=0, ip2=0;
            var ip1t,ip2t;
            var ut1=0, ut2=0;
            var ta = document.getElementById('status_textarea');
            table = tb;
            switching = true;
            // Set the sorting direction to ascending:
            dir = "asc";
            /* Make a loop that will continue until
            no switching has been done: */
            while (switching) {
              // Start by saying: no switching is done:
              switching = false;
              rows = table.rows;
              /* Loop through all table rows (except the
              first, which contains table headers): */
              for (i = 1; i < (rows.length - 1); i++)
              {
                // Start by saying there should be no switching:
                shouldSwitch = false;
                /* Get the two elements you want to compare,
                one from current row and one from the next: */
                x = rows[i].getElementsByTagName("TD")[n];
                y = rows[i + 1].getElementsByTagName("TD")[n];
                /* Check if the two rows should switch place,
                based on the direction, asc or desc: */
                // If this is an IPv4 address, pad so the dotted quad is sorted properly
                if(ipv4 == true)
                {
                  ip1 = x.textContent.split('.').map ( n => +n+256 ).join('.');
                  ip2 = y.textContent.split('.').map ( n => +n+256 ).join('.');

                  if (dir == "asc")
                  {
                    if (ip1 > ip2) {
                      // If so, mark as a switch and break the loop:
                      shouldSwitch = true;
                      break;
                    }
                  }
                  else if (dir == "desc")
                  {
                    if (ip1 < ip2) {
                      // If so, mark as a switch and break the loop:
                      shouldSwitch = true;
                      break;
                    }
                  }
                }
                else if(ut == true)
                {
                    ut1 =parseInt(x.textContent);
                    ut2 =parseInt(y.textContent);
                    if (dir == "asc")
                    {
                      if (ut1 > ut2) {
                        // If so, mark as a switch and break the loop:
                        shouldSwitch = true;
                        break;
                      }
                    }
                    else if (dir == "desc")
                    {
                      if (ut1 < ut2) {
                        // If so, mark as a switch and break the loop:
                        shouldSwitch = true;
                        break;
                      }
                    }
                }
                else
                {
                  if (dir == "asc")
                  {
                    if (x.textContent.toLowerCase() > y.textContent.toLowerCase()) {
                      // If so, mark as a switch and break the loop:
                      shouldSwitch = true;
                      break;
                    }
                  }
                  else if (dir == "desc")
                  {
                    if (x.textContent.toLowerCase() < y.textContent.toLowerCase()) {
                      // If so, mark as a switch and break the loop:
                      shouldSwitch = true;
                      break;
                    }
                  }
                }
              }
              if (shouldSwitch) {
                /* If a switch has been marked, make the switch
                and mark that a switch has been done: */
                rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                switching = true;
                // Each time a switch is done, increase this count by 1:
                switchcount ++;
              } else {
                /* If no switching has been done AND the direction is "asc",
                set the direction to "desc" and run the while loop again. */
                if (switchcount == 0 && dir == "asc") {
                  dir = "desc";
                  switching = true;
                }
              }
            }
            update_text(ta, 'Sorting Done');
            console.log("Count: " + switchcount);
        }


        function filterTable(lid, table) {
            var input, filter, tr, trl, i, txtValue;
            var disp;

            filtered_count=0;
            input = document.getElementById(lid);
            filter = input.value.toUpperCase();
            table = document.getElementById(table);
            tr = table.getElementsByTagName("tr");
            for (i = 1; i < tr.length; i++)
            {
              trl = tr[i];
              if (trl)
              {
                txtValue = trl.textContent || trl.innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1)
                {
                  tr[i].style.display = "";
                  filtered_count++;
                }
                else
                {
                  tr[i].style.display = "none";
                }
              }
            }
            disp = document.getElementById("filter_display");
            disp.value = "Filtered Count: " + filtered_count;
          }


        function send_post(url, action, params, lcount)
        {
            var xhrerror;
            var xhrloaded;
            var xhr = new XMLHttpRequest();

            xhr.onload = function(e)
            {
                xhrloaded = 'true';
            };

            xhr.onerror = function(e)
            {
                xhrerror = 'true';
            };

            xhr.ontimeout = function(e)
            {
                xhrerror = 'true';
            };

            xhr.open ('POST', url, true);
            xhr.setRequestHeader('content-type', 'application/x-www-form-urlencoded');
            xhr.timeout = 10000 + (1000 * lcount);
            xhrerror = 'false';
            xhrloaded = 'false';
            xhr.send(action + params);
        }

        function ajax(xhr, method, url, fload, ferror, ftimeout, timeout, params)
        {
            xhr.open(method, url, true);
            xhr.onload = function(){fload()};
            xhr.onerror = function(){ferror()};
            xhr.ontimeout = function(){ftimeout()};
            xhr.timeout = timeout;
            if(method === "POST")
            {
                xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                xhr.send(params);
            }
            else
            {
                xhr.send();
            }
        }
        </script>



    </head>

    <body>
        <!-- Navigation -->
        <jsp:include page="navtop.jsp"/>
        <!-- END Navigation -->
        <div class="container">
            <h2>Status</h2>
            <textarea class='form-control' id='status_textarea' rows='5' style='resize:none;' readonly >Status Information</textarea>
            <% int i = Integer.parseInt((String)request.getAttribute("numEncoders")); %>
            <% int j = Integer.parseInt((String)request.getAttribute("numDecoders")); %>
            <%= "<h3>Total Units: " + Integer.toString(i+j) + "</h3>" %>
            <%= "<h3>Encoders: " + Integer.toString(i) + "</h3>" %>
            <%= "<h6>" %>
            <%  if(!request.getAttribute("E5100").equals("0"))
                {
                    out.write("&nbsp&nbspE5100: ");
                    out.println(request.getAttribute("E5100"));
                }
            %>
            <%  if(!request.getAttribute("E5200").equals("0"))
                {
                    out.write("&nbsp&nbspE5200: ");
                    out.println(request.getAttribute("E5200"));
                }
            %>
            <%  if(!request.getAttribute("DuetE5-WP").equals("0"))
                {
                    out.write("&nbsp&nbspDuetE5-WP: ");
                    out.println(request.getAttribute("DuetE5-WP"));
                }
            %>
            <%  if(!request.getAttribute("DuetE5-WP-BT").equals("0"))
                {
                    out.write("&nbsp&nbspDuetE5-WP-BT: ");
                    out.println(request.getAttribute("DuetE5-WP-BT"));
                }
            %>
            <%  if(!request.getAttribute("DuetE5-WP-H").equals("0"))
                {
                    out.write("&nbsp&nbspDuetE5-WP-H: ");
                    out.println(request.getAttribute("DuetE5-WP-H"));
                }
            %>
            <%  if(!request.getAttribute("E5-WP").equals("0"))
                {
                    out.write("&nbsp&nbspE5-WP: ");
                    out.println(request.getAttribute("E5-WP"));
                }
            %>
            <%  if(!request.getAttribute("E5-WP-H").equals("0"))
                {
                    out.write("&nbsp&nbspE5-WP-H: ");
                    out.println(request.getAttribute("E5-WP-H"));
                }
            %>
            <%  if(!request.getAttribute("E5-WP-BT").equals("0"))
                {
                    out.write("&nbsp&nbspE5-WP-BT: ");
                    out.println(request.getAttribute("E5-WP-BT"));
                }
            %>
            <%  if(!request.getAttribute("DuetE-5").equals("0"))
                {
                    out.write("&nbsp&nbspDuetE-5: ");
                    out.println(request.getAttribute("DuetE-5"));
                }
            %>
            <%  if(!request.getAttribute("MV5E").equals("0"))
                {
                    out.write("&nbsp&nbspMV5E: ");
                    out.println(request.getAttribute("MV5E"));
                }
            %>
            <%  if(!request.getAttribute("XB5E").equals("0"))
                {
                    out.write("&nbsp&nbspXB5E: ");
                    out.println(request.getAttribute("XB5E"));
                }
            %>

            <%= "</h6>" %>
            <%= "<h3>Decoders: " + Integer.toString(j) + "</h3>" %>
            <%= "<h6>" %>
            <%  if(!request.getAttribute("D5000").equals("0"))
                {
                    out.write("&nbsp&nbspD5000: ");
                    out.println(request.getAttribute("D5000"));
                }
            %>
            <%  if(!request.getAttribute("D5100").equals("0"))
                {
                    out.write("&nbsp&nbspD5100: ");
                    out.println(request.getAttribute("D5100"));
                }
            %>
            <%  if(!request.getAttribute("D5200").equals("0"))
                {
                    out.write("&nbsp&nbspD5200: ");
                    out.println(request.getAttribute("D5200"));
                }
            %>
            <%  if(!request.getAttribute("DuetD-5").equals("0"))
                {
                    out.write("&nbsp&nbspDuetD-5: ");
                    out.println(request.getAttribute("DuetD-5"));
                }
            %>
            <%  if(!request.getAttribute("MV5D").equals("0"))
                {
                    out.write("&nbsp&nbspMV5D: ");
                    out.println(request.getAttribute("MV5D"));
                }
            %>
            <%  if(!request.getAttribute("XB5D").equals("0"))
                {
                    out.write("&nbsp&nbspXB5D: ");
                    out.println(request.getAttribute("XB5D"));
                }
            %>
            <%= "</h6>" %>
            <h2>Endpoints</h2>
            <!--Endpoints List-->
            <!-- Bootstrap alert messages -->
            <c:if test="${not empty message}">
                <div class="alert alert-warning alert-dismissable">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    ${message}
                </div>
            </c:if>
            <c:if test="${not empty vmessage}">
                <div class="alert alert-warning alert-dismissable">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    ${vmessage}
                </div>
            </c:if>
            <c:if test="${not empty umessage}">
                <div class="alert alert-warning alert-dismissable">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    ${umessage}
                </div>
            </c:if>
            <div id="update_danger_alert" style="display:none"  class="alert alert-danger alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                Endpoints are being updated. <strong>IMPORTANT!</strong> Do not power off devices. Approximate time required for firmware update is 10 minutes.
                <div class="progress">
                    <div class="progress-bar progress-bar-danger progress-bar-striped active" id="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0%">
                        <span class="sr-only">0% Complete</span>
                    </div>
                </div>
            </div>
            <div id="update_success_alert" style="display:none" class="alert alert-success alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                Device firmware update complete.
            </div>
            <div id="default_danger_alert" style="display:none"  class="alert alert-danger alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                Endpoints are being defaulted. <strong>IMPORTANT!</strong> Do not power off devices. Approximate time required for factory default is 2 minutes.
                <div class="progress">
                    <div class="progress-bar progress-bar-danger progress-bar-striped active" id="d-progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0%">
                        <span class="sr-only">0% Complete</span>
                    </div>
                </div>
            </div>
            <div id="default_success_alert" style="display:none" class="alert alert-success alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                Device factory default complete.
            </div>
            <!-- END Bootstrap alert message -->
            <form action="/endpoint" method="post" id="endpointForm" role="form" >
                <input type="hidden" id="idEndpoint" name="idEndpoint">
                <input type="hidden" id="action" name="action">
                <input type=text' id='filter_table' onkeyup="filterTable('filter_table', 'unit_table');" placeholder='Filter:' title='Filter' style="margin-bottom: 5px;">
                <input type=text' id='filter_display' placeholder='Filtered Count:' title='Filtered_Count' disabled style="margin-bottom: 5px;">
                <c:choose>
                    <c:when test="${not empty endpointList}">
                        <table  id="unit_table" class="table table-striped">
                            <thead>
                                <tr>
                                    <td id='unit_id' style='width:18%;' onClick="sort_by('unit_id');">ID</td>
                                    <td id='unit_model' style='width:8%;' onClick="sort_by('unit_model');">Model</td>
                                    <td id='unit_serial' style='width:14%;' onClick="sort_by('unit_serial');">Serial&nbspNumber</td>
                                    <td id='unit_ip' style='width:8%;' onClick="sort_by('unit_ip');">IP Address</td>
                                    <td style='width:8%;'>VW Name</td>
                                    <td style='width:4%;'>VW Row</td>
                                    <td style='width:4%;'>VW Col</td>
                                    <td id='unit_uptime' style='width:8%;' onClick="sort_by('unit_uptime');">Uptime (min)</td>
                                    <td id='unit_location' style='width:8%;'  onClick="sort_by('unit_location');">Location</td>
                                    <td id='unit_fw' style='width:6%;'  onClick="sort_by('unit_fw');">FW Version</td>
                                    <td style='width:8%;'>
                                        <button id='updateButton' type='button' class='btn btn-default' onclick="updateEndpoints();">Update</button>
                                        <br>
                                        <input type='checkbox' onclick='checkAllUpdate(this);'>&nbspAll</input>
                                    </td>
                                    <td style='width:8%;'>
                                        <button id='defaultButton' type='button' class='btn btn-default' onclick="defaultEndpoints();">Factory Default</button>
                                        <br>
                                        <input type='checkbox' onclick='checkAllDefault(this);'>&nbspAll</input>
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                <c:forEach var="endpoint" items="${endpointList}">
                                    <c:set var="classSuccess" value=""/>
                                    <c:if test ="${nameEndpoint == endpoint.id}">
                                        <c:set var="classSuccess" value="info"/>
                                    </c:if>
                                    <c:choose>
                                        <c:when test="${endpoint.valid == false}">
                                            <tr style='background-color:yellow'>
                                        </c:when>
                                        <c:otherwise>
                                            <tr>
                                        </c:otherwise>
                                    </c:choose>
                                        <td>${endpoint.id}</td>
                                        <td>${endpoint.model}</td>
                                        <td>${endpoint.serialNumber}</td>
                                        <td>
                                            <a href="http://admin:${password}@${endpoint.ipAddress}" target="_blank">${endpoint.ipAddress}</a>
                                        </td>
                                        <td><c:out value="${ endpoint.isPartOfVideoWall() ? endpoint.getVwName() : ''}"/></td>
                                        <td><c:out value="${ endpoint.vwRow > 0 ? endpoint.vwRow:''}"/></td>
                                        <td><c:out value="${ endpoint.vwColumn > 0 ? endpoint.vwColumn:''}"/></td>
                                        <td>${endpoint.uptime}</td>
                                        <td>${endpoint.location}</td>
                                        <td>${endpoint.fwVersion}</td>
                                        <td><input id="${endpoint.ipAddress}_u" uid='${endpoint.macAddress}' type='checkbox' name='update'> </td>
                                        <td><input id="${endpoint.ipAddress}_d" uid='${endpoint.macAddress}' type='checkbox' name='default'> </td>
                                    </tr>
                                </c:forEach>
                            </tbody>
                        </table>
                    </c:when>
                    <c:otherwise>
                        <br>
                        <div class="alert alert-info">
                            No endpoints discovered
                        </div>
                    </c:otherwise>
                </c:choose>
            </form>
        </div>
        <div class="container">
            <!-- Modal -->
            <div class="modal fade" id="myModal" role="dialog">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Group Selection</h4>
                        </div>
                        <div class="modal-body">
                            <select class='select' multiple>
                            <c:forEach var="groupName" items="${groupListCanHaveChildren}">
                                <option>${groupName}</option>
                            </c:forEach>
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Apply</button>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- container -->
    </body>
</html>
