/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointService;
import com.vsiptv.VLite.MainJFrame;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ThumbnailService {
    private static final Logger LOGGER = Logger.getLogger("ThumbnailService");
    private static final Boolean DEBUG = false;
    FetchThumbnails thumbThread = new FetchThumbnails();
    EndpointService endpointService = new EndpointService();

    public void startThumbnails() {
        LOGGER.log(Level.FINEST, "Start the thread.");
        this.thumbThread.startFetchThumbnails();
    }

    public void stopThumbnails() {
        LOGGER.log(Level.FINEST, "Stop the thread {0}.", Thread.currentThread());
        this.thumbThread.stopFetchThumbnails();
    }

    static {
        LOGGER.setLevel(Level.FINEST);
    }

    class FetchThumbnails
    implements Runnable {
        private volatile Boolean loop = true;

        FetchThumbnails() {
        }

        @Override
        public void run() {
            List<Endpoint> endpointList = ThumbnailService.this.endpointService.getSortedEndpoints();
            LOGGER.log(Level.FINEST, MessageFormat.format("Thread: {0} Loop: {1}", Thread.currentThread(), this.loop.toString()));
            while (this.loop.booleanValue() && !Thread.interrupted()) {
                LOGGER.log(Level.FINEST, MessageFormat.format("Inside While Loop Thread: {0} Loop: {1}", Thread.currentThread(), this.loop.toString()));
                try {
                    for (Endpoint endpoint : endpointList) {
                        String url = "http://" + endpoint.getIpAddress() + "/thumb.jpg";
                        HttpGet get = new HttpGet(url);
                        String temp = "admin:" + MainJFrame.PASSWORD;
                        String auth = Base64.getEncoder().encodeToString(temp.getBytes());
                        get.setHeader("Authorization", "Basic " + auth);
                        CloseableHttpClient client = HttpClientBuilder.create().build();
                        try {
                            LOGGER.log(Level.FINEST, MessageFormat.format("Executiong Get: {0} to HttpClient: {1}", get.toString(), client.toString()));
                            CloseableHttpResponse response = client.execute(get);
                            Throwable throwable = null;
                            try {
                                LOGGER.log(Level.FINEST, "HttpResponse from GET: {0}", response.toString());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (response == null) continue;
                                if (throwable != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                response.close();
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, "Exception: {0}", ex);
                        }
                    }
                    LOGGER.log(Level.FINEST, "Sleeping {0}.", "1 second");
                    Thread.sleep(6000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ThumbnailService.class.getName()).log(Level.SEVERE, null, ex);
                    LOGGER.log(Level.FINEST, "Exited fetchThumbnails {0}.", Thread.currentThread().getName());
                }
            }
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
            LOGGER.log(Level.FINEST, "Exiting Thread {0}.", Thread.currentThread());
        }

        public void startFetchThumbnails() {
            Thread th = new Thread(ThumbnailService.this.thumbThread);
            th.start();
        }

        public void stopFetchThumbnails() {
            this.loop = false;
        }
    }
}

