/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.EndpointService;
import com.vsiptv.VLite.MainJFrame;
import com.vsiptv.VLite.NetworkService;
import com.vsiptv.VLite.User;
import com.vsiptv.VLite.VersionService;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet(name="LoginServlet", urlPatterns={"/login"})
public class LoginServlet
extends HttpServlet {
    static final Logger logger = Logger.getLogger("LoginServlet");

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        logger.log(Level.FINEST, "doPost action={0}", action);
        if (action != null) {
            switch (action) {
                case "login": {
                    this.doLoginAction(request, response);
                    break;
                }
                case "logout": {
                    this.doLogoutAction(request, response);
                }
            }
        }
    }

    private void doLoginAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("user");
        String password = request.getParameter("pass");
        logger.log(Level.FINEST, "POSTing username: {0} password: {1}", new Object[]{username, password});
        User.login(username, password);
        User user = User.getLoggedInUser();
        HttpSession session = request.getSession(true);
        session.setMaxInactiveInterval(0);
        if (user != null) {
            logger.log(Level.FINEST, "User: {0} logged in. Privledge is {1}", new Object[]{user.getName(), user.getPriviledgeLevel().toString()});
            session.setAttribute("user", user);
            this.forwardListEndpoints(request, response);
        } else {
            logger.log(Level.FINEST, "Username or Password incorrect. User is {0}", user);
            this.forwardLogin(request, response);
        }
    }

    private void doLogoutAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (User.getLoggedInUser() != null) {
            logger.log(Level.FINEST, "Logging OUT user {0}", User.getLoggedInUser().getName());
        }
        User.logout();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        this.forwardLogin(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.log(Level.FINEST, "doGet");
        this.forwardLogin(request, response);
    }

    @Override
    public String getServletInfo() {
        return "Simple servlet for login page";
    }

    private void forwardLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String nextJSP = "/jsp/login.jsp";
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("vString", VersionService.getServerVersion());
        req.setAttribute("sString", NetworkService.getSelectedHostAddress());
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }

    @Deprecated
    private void forwardHome(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String nextJSP = "/index.jsp";
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }

    private void forwardListEndpoints(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String nextJSP = "/jsp/config.jsp";
        EndpointService eps = new EndpointService();
        req.setAttribute("loggedInUser", User.getLoggedInUser().getName());
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("vString", VersionService.getServerVersion());
        req.setAttribute("sString", NetworkService.getSelectedHostAddress());
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        req.setAttribute("endpointList", eps.discoverEndpoints());
        req.setAttribute("numEncoders", eps.encoderCount());
        req.setAttribute("numDecoders", eps.decoderCount());
        req.setAttribute("D5000", eps.modelCount("D5000"));
        req.setAttribute("D5100", eps.modelCount("D5100"));
        req.setAttribute("D5200", eps.modelCount("D5200"));
        req.setAttribute("DuetD-5", eps.modelCount("DuetD-5"));
        req.setAttribute("MV5D", eps.modelCount("MV5D"));
        req.setAttribute("XB5D", eps.modelCount("XB5D"));
        req.setAttribute("E5100", eps.modelCount("E5100"));
        req.setAttribute("E5200", eps.modelCount("E5200"));
        req.setAttribute("DuetE5-WP", eps.modelCount("DuetE5-WP"));
        req.setAttribute("DuetE5-WP-BT", eps.modelCount("DuetE5-WP-BT"));
        req.setAttribute("DuetE5-WP-H", eps.modelCount("DuetE5-WP-H"));
        req.setAttribute("E5-WP", eps.modelCount("E5-WP"));
        req.setAttribute("E5-WP-BT", eps.modelCount("E5-WP-BT"));
        req.setAttribute("E5-WP-H", eps.modelCount("E5-WP-H"));
        req.setAttribute("DuetE-5", eps.modelCount("DuetE-5"));
        req.setAttribute("MV5E", eps.modelCount("MV5E"));
        req.setAttribute("XB5E", eps.modelCount("XB5E"));
        if (VersionService.firmwareUpdatePossible().booleanValue()) {
            req.setAttribute("message", VersionService.getUpdateMessage());
        }
        if (eps.unvisifiedCount() > 0) {
            req.setAttribute("vmessage", "Unit(s) in yellow need visification!!!!!");
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }

    static {
        logger.setLevel(Level.FINEST);
    }
}

