/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Group;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Endpoint
extends Group
implements Serializable {
    private Map<String, String> parameterMap;
    private boolean deviceParametersNeedUpdate;
    private boolean parameterMapNeedsUpdateFromDevice;
    private String id;
    private String model;
    private String ipAddress;
    private int vwRow;
    private int vwColumn;
    private String vwName;
    private Boolean vwIsEnabled;
    private Boolean vwIsActive;
    private String macAddress;
    private String location;
    private String fwVersion;
    private String streamAddress;
    private String streamHost;
    private String uptime;
    private boolean valid;

    public static Endpoint createFromParameterMap(Map<String, String> parameterMap) {
        if (parameterMap.containsKey("UNIT.SERIAL") && parameterMap.containsKey("UNIT.MODEL") && parameterMap.containsKey("IP.ADDRESS")) {
            return new Endpoint(parameterMap);
        }
        return null;
    }

    private Endpoint(Map<String, String> parameterMap) {
        super(parameterMap.get("UNIT.SERIAL"));
        this.setCanHaveChildren(false);
        this.parameterMap = parameterMap;
        LOGS.setLevel(Level.FINEST);
        this.setName(parameterMap.get("UNIT.SERIAL"));
        this.model = parameterMap.get("UNIT.MODEL");
        this.ipAddress = parameterMap.get("IP.ADDRESS");
        this.id = parameterMap.get("UNIT.ID");
        this.uptime = parameterMap.getOrDefault("UPTIME", "NA");
        this.setVwRow(parameterMap.containsKey("VW.ROW") ? Integer.parseInt(parameterMap.get("VW.ROW")) : 0);
        this.setVwColumn(parameterMap.containsKey("VW.COLUMN") ? Integer.parseInt(parameterMap.get("VW.COLUMN")) : 0);
        this.vwName = parameterMap.getOrDefault("VW.NAME", null);
        this.vwIsEnabled = parameterMap.containsKey("VW.ENABLED") ? parameterMap.get("VW.ENABLED").equals("TRUE") : false;
        this.vwIsActive = parameterMap.containsKey("VW.ACTIVE") ? parameterMap.get("VW.ACTIVE").equals("TRUE") : false;
        this.macAddress = parameterMap.get("MAC.ADDRESS");
        this.streamAddress = parameterMap.getOrDefault("STREAM.ADDRESS", "NA");
        this.streamHost = parameterMap.getOrDefault("STREAM.HOST", null);
        this.location = parameterMap.getOrDefault("UNIT.LOCATION", "NA");
        this.fwVersion = parameterMap.getOrDefault("UNIT.FIRMWARE", "NA");
        this.valid = true;
    }

    @Override
    public void tuneIntoEndpoint(Endpoint source, Boolean vwActive) {
        String sourceIpAddress = source.getIpAddress();
        String apiCommand = "CMD=START&";
        apiCommand = apiCommand + "UNIT.ID=" + this.getId() + "&";
        apiCommand = apiCommand + "STREAM.HOST=" + sourceIpAddress + "&";
        apiCommand = apiCommand + "STREAM.CONNECT=TRUE&";
        this.setVwIsActive(vwActive);
        apiCommand = vwActive != false ? apiCommand + "VW.ACTIVE=TRUE&" : apiCommand + "VW.ACTIVE=FALSE&";
        apiCommand = apiCommand + "CMD=END";
        LOGS.log(Level.FINEST, "tuneIntoEndpoint - apiCommand: " + apiCommand);
        this.sendAPICommand(apiCommand);
        this.setStreamHost(sourceIpAddress);
    }

    private Map<String, String> parameterMapFromData(String in) {
        String[] pairs = in.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs) {
            try {
                String[] keyValue = pair.split("=");
                map.put(keyValue[0], keyValue[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public String sendAPICommand(String cmd) {
        String data = null;
        try {
            byte[] apiCommandBuffer = cmd.getBytes();
            int port = 8000;
            String group = this.ipAddress;
            byte[] bytes = new byte[4];
            InetAddress add1 = InetAddress.getByAddress(bytes);
            try (DatagramSocket socket = new DatagramSocket();){
                InetAddress address = InetAddress.getByName(group);
                DatagramPacket pack = new DatagramPacket(apiCommandBuffer, apiCommandBuffer.length, address, port);
                socket.setSoTimeout(1000);
                socket.send(pack);
                byte[] apiResponseBuffer = new byte[1500];
                DatagramPacket apiResponse = new DatagramPacket(apiResponseBuffer, apiResponseBuffer.length);
                try {
                    socket.receive(apiResponse);
                    add1 = apiResponse.getAddress();
                }
                catch (SocketTimeoutException ex) {
                    System.out.println(ex);
                }
                data = new String(apiResponse.getData());
                LOGS.log(Level.FINEST, "apiResponse.getData(): {0} Address: {1}", new Object[]{data, add1.getHostAddress()});
            }
            catch (Exception ex) {
                LOGS.log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            LOGS.log(Level.SEVERE, null, ex);
        }
        return data;
    }

    public boolean isEncoder() {
        return this.getModel().equals("E5100") || this.getModel().equals("DuetE5-WP") || this.getModel().equals("DuetE5-WP-BT") || this.getModel().equals("DuetE5-WP-H") || this.getModel().equals("DuetE-5") || this.getModel().equals("E5200") || this.getModel().equals("E5-WP") || this.getModel().equals("E5-WP-BT") || this.getModel().equals("E5-WP-H") || this.getModel().equals("XB5E") || this.getModel().equals("MV5E");
    }

    public boolean isDecoder() {
        return this.getModel().equals("D5000") || this.getModel().equals("D5100") || this.getModel().equals("D5200") || this.getModel().equals("MV5D") || this.getModel().equals("XB5D") || this.getModel().equals("DuetD-5");
    }

    public Boolean isPartOfVideoWall() {
        return this.getVwIsEnabled() != false && this.getVwName() != null;
    }

    @Override
    public Boolean isDisplay() {
        return this.isDecoder();
    }

    public Endpoint(String ipaddr, String groupName) {
        super(groupName);
        this.ipAddress = ipaddr;
    }

    public Map<String, String> getParameterMap() {
        if (this.parameterMap == null) {
            System.out.println("getting parameter map from device " + this.ipAddress);
            assert (this.ipAddress != null);
            String giveMeYourParameterMap = "CMD=START&UNIT.ID=ALL&QUERY.ALL=SHORT&CMD=END";
            String pMapData = this.sendAPICommand(giveMeYourParameterMap);
            Map<String, String> pMap = this.parameterMapFromData(pMapData);
            return pMap;
        }
        return this.parameterMap;
    }

    public String getSerialNumber() {
        String groupName = super.getName();
        if (this.parameterMap != null) {
            String parameterMapName = this.parameterMap.get("UNIT.SERIAL");
            assert (groupName.equals(parameterMapName));
        }
        return groupName;
    }

    public String getId() {
        String lid = "";
        if (this.parameterMap != null) {
            lid = this.parameterMap.get("UNIT.ID");
        }
        return lid;
    }

    @Override
    public String getDisplayName() {
        if (this.parameterMap != null) {
            String endpointName = this.parameterMap.getOrDefault("UNIT.ID", "No UNIT.ID in parameterMap");
            return endpointName;
        }
        return "No parameterMap";
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
    }

    public void setID(String id) {
        this.parameterMap.put("SET.UNIT_ID", id);
    }

    public String getModel() {
        return this.model;
    }

    @Deprecated
    public void setModel(String model) {
        this.model = model;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Deprecated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUptime() {
        String temp = "NA".equals(this.uptime) ? "NA" : Integer.toString(Math.round(Integer.parseInt(this.uptime) / 60));
        return temp;
    }

    public int getVwRow() {
        return this.vwRow + 1;
    }

    @Deprecated
    public final void setVwRow(int vwRow) {
        this.vwRow = vwRow - 1;
    }

    public int getVwColumn() {
        return this.vwColumn + 1;
    }

    @Deprecated
    public final void setVwColumn(int vwColumn) {
        this.vwColumn = vwColumn - 1;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @Deprecated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getLocation() {
        return this.location;
    }

    @Deprecated
    public void setLocation(String location) {
        this.location = location;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public int compareFwVersion(String v1) {
        int ret;
        String v2 = this.getFwVersion();
        String[] subvers = v1.split("\\.");
        try {
            int v1_1 = Integer.parseInt(subvers[0]);
            int v1_2 = Integer.parseInt(subvers[1]);
            String[] svers = subvers[2].split("-");
            int v1_3 = Integer.parseInt(svers[0]);
            subvers = v2.split("\\.");
            int v2_1 = Integer.parseInt(subvers[0]);
            int v2_2 = Integer.parseInt(subvers[1]);
            svers = subvers[2].split("-");
            int v2_3 = Integer.parseInt(svers[0]);
            ret = v1_1 < v2_1 ? 1 : (v1_1 > v2_1 ? -1 : (v1_2 < v2_1 ? 1 : (v1_2 > v2_2 ? -1 : (v1_3 < v2_3 ? 1 : (v1_3 > v2_3 ? -1 : 0)))));
        }
        catch (Exception ex) {
            LOGS.log(Level.FINEST, "compareFwVersion: Non parseable integer in firmware version use new method ");
            ret = 0;
        }
        return ret;
    }

    public String getStreamAddress() {
        return this.streamAddress;
    }

    public String getStreamHost() {
        return this.streamHost;
    }

    @Deprecated
    public void setStreamHost(String streamHost) {
        this.streamHost = streamHost;
    }

    public String getVwName() {
        return this.vwName;
    }

    public Boolean getVwIsEnabled() {
        return this.vwIsEnabled;
    }

    public void setVwIsActive(Boolean vwIsActive) {
        this.vwIsActive = vwIsActive;
    }

    public Boolean getVwIsActive() {
        return this.vwIsActive;
    }

    public String groupsToString() {
        String groupStr = new String();
        for (Group g : this.getChildren()) {
            groupStr = groupStr + " " + g.toString();
        }
        return groupStr;
    }

    @Override
    public String toString() {
        return "Endpoint{ id=" + this.id + ", model=" + this.model + ", serialNumber=" + this.getSerialNumber() + ", ipAddress= " + this.ipAddress + ", vwRow=" + this.vwRow + ", vwColumn=" + this.vwColumn + ", vwIsEnabled=" + this.getVwIsEnabled() + ", vwIsActive=" + this.getVwIsActive() + ", macAddress=" + this.macAddress + ", streamAddress=" + this.streamAddress + ", streamHost=" + this.streamHost + ", location=" + this.location + '}';
    }
}

