/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointService;
import com.vsiptv.VLite.Group;
import com.vsiptv.VLite.MainJFrame;
import com.vsiptv.VLite.NetworkService;
import com.vsiptv.VLite.User;
import com.vsiptv.VLite.VersionService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@WebServlet(name="ConfigurationServlet", urlPatterns={"/config"})
public class ConfigurationServlet
extends HttpServlet {
    EndpointService endpointService = new EndpointService();
    Logger logger = Logger.getLogger(this.getClass().getName());
    URL fileURLE = this.getClass().getResource("/META-INF/resources/binaries/E5x_web.e5x");
    URL fileURLD = this.getClass().getResource("/META-INF/resources/binaries/D5x_web.d5x");
    final File intfileE;
    final File intfileD;
    int gcount = 1;
    CloseableHttpClient httpclient = HttpClients.custom().setMaxConnTotal(680).setMaxConnPerRoute(5).build();
    Thread[] update_thread;
    ResponseHandler<String> rh = new ResponseHandler<String>(){

        @Override
        public String handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            ConfigurationServlet.this.logger.log(Level.INFO, MessageFormat.format("Got: {0} Count: {1}", response.toString(), ConfigurationServlet.this.gcount));
            ++ConfigurationServlet.this.gcount;
            if (statusLine.getStatusCode() >= 300) {
                // empty if block
            }
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            return response.toString();
        }
    };

    public ConfigurationServlet() throws IOException {
        this.intfileE = new File("firmware_E");
        FileUtils.copyURLToFile(this.fileURLE, this.intfileE);
        this.intfileD = new File("firmware_D");
        FileUtils.copyURLToFile(this.fileURLD, this.intfileD);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        EndpointService eps = new EndpointService();
        if (action != null) {
            action.getClass();
        } else {
            this.logger.setLevel(Level.FINEST);
            List<Endpoint> result = eps.discoverEndpoints();
            this.forwardListEndpoints(req, resp, result, eps);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        this.logger.log(Level.INFO, "Action: {0}", action);
        switch (action) {
            case "config": {
                this.configEndpointAction(req, resp);
                break;
            }
            case "update": {
                this.updateEndpointAction(req, resp);
                break;
            }
            case "update_many": {
                this.updateManyEndpointAction(req, resp);
                break;
            }
            case "default": {
                this.defaultEndpointAction(req, resp);
                break;
            }
            case "addGroup": {
                this.addGroupAction(req, resp);
            }
        }
    }

    private void searchEndpointByName(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String endpointName = req.getParameter("endpointName");
        EndpointService eps = new EndpointService();
        List<Endpoint> result = eps.searchEndpointsByName(endpointName);
        this.forwardListEndpoints(req, resp, result, eps);
    }

    private void configEndpointAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String encoderMac = req.getParameter("encoder");
        String decoderMac = req.getParameter("decoder");
        EndpointService eps = new EndpointService();
        this.logger.log(Level.FINEST, "Encoder: {0} Decoder: {1}", new Object[]{encoderMac, decoderMac});
        try {
            Endpoint decoder = this.endpointService.getEndpointByMacAddress(decoderMac);
            Endpoint encoder = this.endpointService.getEndpointByMacAddress(encoderMac);
            this.logger.log(Level.FINEST, "Encoder: {0} Decoder: {1}", new Object[]{encoder.toString(), decoder.toString()});
            decoder.tuneIntoEndpoint(encoder, true);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
        }
        String result = "Tuning endpoint " + decoderMac + " into endpoint " + encoderMac;
        this.forwardConfig(req, resp, result, eps);
    }

    private void tester(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.log(Level.INFO, "Thread: {0}\n", Thread.currentThread().getName());
        try {
            Thread.sleep(7700L);
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigurationServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateEndpointAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String endpointMac = req.getParameter("uid");
        String count = req.getParameter("count");
        String password = MainJFrame.PASSWORD;
        String result = "Sending Update.";
        boolean post = true;
        EndpointService eps = new EndpointService();
        String temp = "admin:" + password;
        String auth = Base64.getEncoder().encodeToString(temp.getBytes());
        if (post) {
            try {
                Endpoint endpoint = this.endpointService.getEndpointByMacAddress(endpointMac);
                this.sendPost(endpoint, count, auth);
            }
            catch (Exception ex) {
                System.out.println("Exception: " + ex);
            }
        }
    }

    private void updateManyEndpointAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String count = req.getParameter("count");
        String password = MainJFrame.PASSWORD;
        String result = "Sending Updates.";
        boolean post = true;
        EndpointService eps = new EndpointService();
        String temp = "admin:" + password;
        String auth = Base64.getEncoder().encodeToString(temp.getBytes());
        this.logger.log(Level.INFO, "Count: {0}", count);
        int mcount = Integer.parseInt(count);
        this.gcount = 1;
        for (int ep = 1; ep <= mcount; ++ep) {
            this.logger.log(Level.INFO, "EP#: {0}", ep);
            String endpointMac = req.getParameter("uid_" + ep);
            this.logger.log(Level.INFO, "UID: {0}", endpointMac);
            if (!post) continue;
            try {
                Endpoint endpoint = this.endpointService.getEndpointByMacAddress(endpointMac);
                this.sendPost(endpoint, Integer.toString(ep), auth);
                Thread.sleep(20L);
                continue;
            }
            catch (Exception ex) {
                System.out.println("ExceptionE: " + ex);
            }
        }
    }

    private void defaultEndpointAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String endpointMac = req.getParameter("uid");
        String count = req.getParameter("count");
        EndpointService eps = new EndpointService();
        try {
            Endpoint endpoint = this.endpointService.getEndpointByMacAddress(endpointMac);
            this.sendDefault(endpoint, count);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
        }
        String result = "Make the result mean something!";
    }

    private void addGroupAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String name = req.getParameter("newGroupName");
        Group group = Group.createOrGetGroup(name);
        EndpointService eps = new EndpointService();
        this.logger.log(Level.FINEST, "Group: {0}", group.toString());
        String result = "Make the result mean something!";
        this.forwardConfig(req, resp, result, eps);
    }

    private void sendPost(Endpoint endpoint, String count, String auth) throws Exception {
        int index = Integer.parseInt(count);
        int new_method = endpoint.compareFwVersion("1.8.53");
        String url = new_method >= 0 ? "http://" + endpoint.getIpAddress() + "/cgi-bin/handler.cgi" : "http://" + endpoint.getIpAddress() + "/cgi-bin/upload_fw.cgi";
        boolean xit = false;
        if (!xit) {
            HttpPost post = new HttpPost(url);
            post.setHeader("Authorization", "Basic " + auth);
            if (new_method >= 0) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                builder.addTextBody("CMD", "UPDATE_FIRMWARE");
                if (endpoint.isEncoder()) {
                    builder.addPart("file", new FileBody(this.intfileE));
                }
                if (endpoint.isDecoder()) {
                    builder.addPart("file", new FileBody(this.intfileD));
                }
                post.setEntity(builder.build());
            } else {
                FileEntity fileentity = endpoint.isEncoder() ? new FileEntity(this.intfileE) : new FileEntity(this.intfileD);
                fileentity.setContentType("application/binary");
                post.setEntity(fileentity);
            }
            this.logger.log(Level.INFO, MessageFormat.format("Executing POST: {0} Count: {1}\n\n\n", post.toString(), count));
            this.Poster(this.httpclient, post);
        }
    }

    private void Poster(CloseableHttpClient client, HttpPost post) {
        Thread t = new Thread(() -> {
            try {
                String string = client.execute((HttpUriRequest)post, this.rh);
            }
            catch (Exception ex) {
                Logger.getLogger(ConfigurationServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        t.start();
    }

    private void sendDefault(Endpoint endpoint, String count) throws Exception {
        int new_method = endpoint.compareFwVersion("2.3.53");
        if (new_method >= 0) {
            String apiCommand = "CMD=START&UNIT.ID=ALL&";
            apiCommand = apiCommand + "UNIT.FACTORY_DEFAULT=TRUE&UNIT.REBOOT=TRUE&";
            apiCommand = apiCommand + "CMD=END";
            String data = endpoint.sendAPICommand(apiCommand);
            this.logger.log(Level.FINEST, "Factory Default sent to: {0} Count: {1}\n", new Object[]{endpoint.getIpAddress(), count});
        } else {
            String apiCommand = "CMD=START&UNIT.ID=ALL&";
            apiCommand = apiCommand + "FACTORY.DEFAULT=TRUE&REBOOT=TRUE&";
            apiCommand = apiCommand + "CMD=END";
            String data = endpoint.sendAPICommand(apiCommand);
            this.logger.log(Level.FINEST, "Factory Default sent to: {0} Count: {1}\n", new Object[]{endpoint.getIpAddress(), count});
        }
    }

    private void forwardListEndpoints(HttpServletRequest req, HttpServletResponse resp, List endpointList, EndpointService eps) throws ServletException, IOException {
        String nextJSP = "/jsp/config.jsp";
        req.setAttribute("loggedInUser", User.getLoggedInUser().getName());
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("vString", VersionService.getServerVersion());
        req.setAttribute("sString", NetworkService.getSelectedHostAddress());
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        req.setAttribute("endpointList", endpointList);
        req.setAttribute("numEncoders", eps.encoderCount());
        req.setAttribute("numDecoders", eps.decoderCount());
        req.setAttribute("D5000", eps.modelCount("D5000"));
        req.setAttribute("D5100", eps.modelCount("D5100"));
        req.setAttribute("D5200", eps.modelCount("D5200"));
        req.setAttribute("DuetD-5", eps.modelCount("DuetD-5"));
        req.setAttribute("MV5D", eps.modelCount("MV5D"));
        req.setAttribute("XB5D", eps.modelCount("XB5D"));
        req.setAttribute("E5100", eps.modelCount("E5100"));
        req.setAttribute("E5200", eps.modelCount("E5200"));
        req.setAttribute("DuetE5-WP", eps.modelCount("DuetE5-WP"));
        req.setAttribute("DuetE5-WP-BT", eps.modelCount("DuetE5-WP-BT"));
        req.setAttribute("DuetE5-WP-H", eps.modelCount("DuetE5-WP-H"));
        req.setAttribute("E5-WP", eps.modelCount("E5-WP"));
        req.setAttribute("E5-WP-BT", eps.modelCount("E5-WP-BT"));
        req.setAttribute("E5-WP-H", eps.modelCount("E5-WP-H"));
        req.setAttribute("DuetE-5", eps.modelCount("DuetE-5"));
        req.setAttribute("MV5E", eps.modelCount("MV5E"));
        req.setAttribute("XB5E", eps.modelCount("XB5E"));
        if (VersionService.firmwareUpdatePossible().booleanValue()) {
            req.setAttribute("message", VersionService.getUpdateMessage());
        }
        if (eps.unvisifiedCount() > 0) {
            req.setAttribute("vmessage", "Unit(s) in yellow need visification!!!!!");
            this.logger.log(Level.INFO, "Unvisified: {0}", eps.unvisifiedCount());
        }
        req.setAttribute("groupListNames", Group.getGroupList().stream().map(g0 -> g0.getName()).collect(Collectors.toList()));
        req.setAttribute("groupList", Group.getGroupList().stream().filter(g1 -> g1.getChildren().size() > 0).collect(Collectors.toList()));
        req.setAttribute("groupListAll", Group.getGroupList());
        req.setAttribute("groupListCanHaveChildren", Group.getGroupList().stream().filter(g1 -> g1.getCanHaveChildren()).collect(Collectors.toList()));
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }

    private void forwardConfig(HttpServletRequest req, HttpServletResponse resp, String result, EndpointService eps) throws ServletException, IOException {
        String nextJSP = "/jsp/config.jsp";
        req.setAttribute("loggedInUser", User.getLoggedInUser().getName());
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        req.setAttribute("text", result);
        req.setAttribute("numEncoders", eps.encoderCount());
        req.setAttribute("numDecoders", eps.decoderCount());
        req.setAttribute("D5000", eps.modelCount("D5000"));
        req.setAttribute("D5100", eps.modelCount("D5100"));
        req.setAttribute("DuetD-5", eps.modelCount("DuetD-5"));
        req.setAttribute("MV5D", eps.modelCount("MV5D"));
        req.setAttribute("XB5D", eps.modelCount("XB5D"));
        req.setAttribute("E5100", eps.modelCount("E5100"));
        req.setAttribute("DuetE5-WP", eps.modelCount("DuetE5-WP"));
        req.setAttribute("DuetE5-WP-BT", eps.modelCount("DuetE5-WP-BT"));
        req.setAttribute("DuetE5-WP-H", eps.modelCount("DuetE5-WP-H"));
        req.setAttribute("DuetE-5", eps.modelCount("DuetE-5"));
        req.setAttribute("MV5E", eps.modelCount("MV5E"));
        req.setAttribute("XB5E", eps.modelCount("XB5E"));
        if (result.contains("INVALID")) {
            req.setAttribute("umessage", "Cannot Not Update. Visify INVALID!!!!!");
        }
        if (VersionService.firmwareUpdatePossible().booleanValue()) {
            req.setAttribute("message", VersionService.getUpdateMessage());
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }
}

